/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcointoyou;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.bitcointoyou.dto.account.BitcointoyouBalance;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouLevel;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouMarketData;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouOrderBook;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouPublicTrade;
import org.knowm.xchange.bitcointoyou.dto.marketdata.BitcointoyouTicker;
import org.knowm.xchange.bitcointoyou.dto.trade.BitcointoyouOrderInfo;
import org.knowm.xchange.bitcointoyou.dto.trade.BitcointoyouOrderResponse;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;

public final class BitcointoyouAdapters {
    private BitcointoyouAdapters() {
    }

    public static Ticker adaptBitcointoyouTicker(BitcointoyouTicker bitcointoyouTicker, CurrencyPair currencyPair) {
        return BitcointoyouAdapters.adaptBitcointoyouTicker(bitcointoyouTicker.getBitcointoyouMarketData(), currencyPair);
    }

    static Ticker adaptBitcointoyouTicker(BitcointoyouMarketData bitcointoyouMarketData, CurrencyPair currencyPair) {
        BigDecimal last = bitcointoyouMarketData.getLast();
        BigDecimal bid = bitcointoyouMarketData.getBuy();
        BigDecimal ask = bitcointoyouMarketData.getSell();
        BigDecimal high = bitcointoyouMarketData.getHigh();
        BigDecimal low = bitcointoyouMarketData.getLow();
        BigDecimal volume = bitcointoyouMarketData.getVolume();
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).volume(volume).timestamp(DateUtils.fromUnixTime((long)bitcointoyouMarketData.getDate())).build();
    }

    public static OrderBook adaptBitcointoyouOrderBook(BitcointoyouOrderBook depth, CurrencyPair currencyPair) {
        List<LimitOrder> asks = BitcointoyouAdapters.adaptBitcointoyouPublicOrders(depth.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = BitcointoyouAdapters.adaptBitcointoyouPublicOrders(depth.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(new Date(), asks, bids);
    }

    static List<LimitOrder> adaptBitcointoyouPublicOrders(List<List<BigDecimal>> list, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<BitcointoyouLevel> levels = new ArrayList<BitcointoyouLevel>();
        for (List<BigDecimal> rawLevel : list) {
            levels.add(BitcointoyouAdapters.adaptRawBitcointoyouLevel(rawLevel));
        }
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        for (BitcointoyouLevel level : levels) {
            LimitOrder limitOrder = new LimitOrder.Builder(orderType, (Instrument)currencyPair).originalAmount(level.getAmount()).limitPrice(level.getLimit()).build();
            orders.add(limitOrder);
        }
        return orders;
    }

    static BitcointoyouLevel adaptRawBitcointoyouLevel(List<BigDecimal> rawLevel) {
        return new BitcointoyouLevel(rawLevel.get(0), rawLevel.get(1));
    }

    public static Trades adaptBitcointoyouPublicTrades(BitcointoyouPublicTrade[] bitcointoyouPublicTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        for (BitcointoyouPublicTrade bitcointoyouTrade : bitcointoyouPublicTrades) {
            trades.add(BitcointoyouAdapters.adaptBitcointoyouPublicTrade(bitcointoyouTrade, currencyPair));
        }
        return new Trades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    private static Trade adaptBitcointoyouPublicTrade(BitcointoyouPublicTrade bitcointoyouTrade, CurrencyPair currencyPair) {
        Order.OrderType type = bitcointoyouTrade.getType().equalsIgnoreCase("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        Date timestamp = BitcointoyouAdapters.fromRfc3339DateStringQuietly(bitcointoyouTrade.getDate().toString());
        return new Trade.Builder().type(type).originalAmount(bitcointoyouTrade.getAmount()).currencyPair(currencyPair).price(bitcointoyouTrade.getPrice()).timestamp(timestamp).id(bitcointoyouTrade.getTid().toString()).build();
    }

    public static List<Balance> adaptBitcointoyouBalances(BitcointoyouBalance bitcointoyouBalances) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        if (bitcointoyouBalances != null && bitcointoyouBalances.getoReturn() != null && bitcointoyouBalances.getoReturn().size() > 0) {
            Map<String, BigDecimal> balancesMap = bitcointoyouBalances.getoReturn().get(0);
            for (Map.Entry<String, BigDecimal> balance : balancesMap.entrySet()) {
                Currency currency = Currency.getInstance((String)balance.getKey());
                balances.add(new Balance(currency, balance.getValue()));
            }
        }
        return balances;
    }

    public static OpenOrders adaptBitcointoyouOpenOrders(BitcointoyouOrderResponse bitcointoyouOpenOrders) {
        List<BitcointoyouOrderInfo> ordersInfo;
        ArrayList<LimitOrder> openOrders = new ArrayList<LimitOrder>();
        if (bitcointoyouOpenOrders != null && bitcointoyouOpenOrders.getOrderList() != null && (ordersInfo = bitcointoyouOpenOrders.getOrderList()) != null && !ordersInfo.isEmpty()) {
            for (BitcointoyouOrderInfo orderInfo : ordersInfo) {
                if (orderInfo.getAsset() == null || orderInfo.getCurrency() == null) continue;
                CurrencyPair currencyPair = new CurrencyPair(orderInfo.getAsset(), orderInfo.getCurrency());
                openOrders.add(BitcointoyouAdapters.adaptBitcointoyouOpenOrder(bitcointoyouOpenOrders, currencyPair));
            }
        }
        return new OpenOrders(openOrders);
    }

    private static LimitOrder adaptBitcointoyouOpenOrder(BitcointoyouOrderResponse openOrder, CurrencyPair currencyPair) {
        if (openOrder != null && openOrder.getOrderList() != null && openOrder.getOrderList().isEmpty()) {
            BitcointoyouOrderInfo orderInfo = openOrder.getOrderList().get(0);
            Date orderDate = BitcointoyouAdapters.fromRfc3339DateStringQuietly(orderInfo.getDateCreated());
            return BitcointoyouAdapters.adaptBitcointoyouSingleOpenOrder(orderInfo, currencyPair, orderDate);
        }
        return null;
    }

    private static LimitOrder adaptBitcointoyouSingleOpenOrder(BitcointoyouOrderInfo orderInfo, CurrencyPair currencyPair, Date orderDate) {
        Order.OrderType type = orderInfo.getAction().equals("buy") ? Order.OrderType.BID : Order.OrderType.ASK;
        return new LimitOrder.Builder(type, (Instrument)currencyPair).limitPrice(orderInfo.getPrice()).originalAmount(orderInfo.getAmount()).id(orderInfo.getId()).timestamp(orderDate).build();
    }

    public static Collection<Order> adaptBitcointoyouOrderToOrdersCollection(BitcointoyouOrderResponse bitcointoyouOrderResponse) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (bitcointoyouOrderResponse != null && bitcointoyouOrderResponse.getOrderList() != null && !bitcointoyouOrderResponse.getOrderList().isEmpty()) {
            for (BitcointoyouOrderInfo orderInfo : bitcointoyouOrderResponse.getOrderList()) {
                Date orderDate;
                LimitOrder order = BitcointoyouAdapters.adaptBitcointoyouSingleOpenOrder(orderInfo, null, orderDate = BitcointoyouAdapters.fromRfc3339DateStringQuietly(orderInfo.getDateCreated()));
                if (order == null) continue;
                orders.add((Order)order);
            }
        }
        return orders;
    }

    private static Date fromRfc3339DateStringQuietly(String orderDate) {
        try {
            return DateUtils.fromRfc3339DateString((String)orderDate);
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }
}

