/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.bitcoinde.BitcoindeUtils;
import org.knowm.xchange.bitcoinde.v4.BitcoindeExchange;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeException;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderState;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeResponse;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeType;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeIdResponse;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyOrdersWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyTrade;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyTradesWrapper;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.LimitOrder;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcoindeTradeServiceRaw
extends BitcoindeBaseService {
    private final SynchronizedValueFactory<Long> nonceFactory;

    protected BitcoindeTradeServiceRaw(BitcoindeExchange exchange) {
        super(exchange);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public BitcoindeMyOrdersWrapper getBitcoindeMyOrders(CurrencyPair currencyPair, BitcoindeType type, BitcoindeOrderState state, Date start, Date end, Integer page) throws IOException {
        try {
            String endAsString;
            String typeAsString = type != null ? type.getValue() : null;
            Integer stateAsInteger = state != null ? Integer.valueOf(state.getValue()) : null;
            String startAsString = start != null ? BitcoindeUtils.rfc3339Timestamp(start) : null;
            String string = endAsString = end != null ? BitcoindeUtils.rfc3339Timestamp(end) : null;
            if (currencyPair == null) {
                return this.bitcoinde.getMyOrders(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, typeAsString, stateAsInteger, startAsString, endAsString, page);
            }
            return this.bitcoinde.getMyOrders(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindePair(currencyPair), typeAsString, stateAsInteger, startAsString, endAsString, page);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeResponse bitcoindeCancelOrders(String orderId, CurrencyPair currencyPair) throws IOException {
        try {
            String currPair = BitcoindeUtils.createBitcoindePair(currencyPair);
            return this.bitcoinde.deleteOrder(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, orderId, currPair);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeIdResponse bitcoindePlaceLimitOrder(LimitOrder order) throws IOException {
        try {
            String side = BitcoindeUtils.createBitcoindeType(order.getType());
            String bitcoindeCurrencyPair = BitcoindeUtils.createBitcoindePair(order.getCurrencyPair());
            return this.bitcoinde.createOrder(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, order.getOriginalAmount(), order.getLimitPrice(), bitcoindeCurrencyPair, side);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeMyTradesWrapper getBitcoindeMyTrades(CurrencyPair tradingPair, BitcoindeType type, BitcoindeMyTrade.State state, Boolean actionRequired, BitcoindeMyTrade.PaymentMethod paymentMethod, Date start, Date end, Integer page) throws IOException {
        String typeAsString = type != null ? type.getValue() : null;
        Integer stateAsInteger = state != null ? Integer.valueOf(state.getValue()) : null;
        Integer actionRequiredAsInteger = actionRequired != null ? BitcoindeUtils.createBitcoindeBoolean(actionRequired) : null;
        Integer paymentMethodeAsInteger = paymentMethod != null ? Integer.valueOf(paymentMethod.getValue()) : null;
        String startAsString = start != null ? BitcoindeUtils.rfc3339Timestamp(start) : null;
        String endAsString = end != null ? BitcoindeUtils.rfc3339Timestamp(end) : null;
        try {
            if (tradingPair == null) {
                return this.bitcoinde.getMyTrades(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, typeAsString, stateAsInteger, actionRequiredAsInteger, paymentMethodeAsInteger, startAsString, endAsString, page);
            }
            return this.bitcoinde.getMyTrades(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindePair(tradingPair), typeAsString, stateAsInteger, actionRequiredAsInteger, paymentMethodeAsInteger, startAsString, endAsString, page);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }
}

