/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.io.IOException;
import org.knowm.xchange.bitcoinde.BitcoindeUtils;
import org.knowm.xchange.bitcoinde.v4.BitcoindeExchange;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeException;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeCompactOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeTradesWrapper;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeBaseService;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeOrderbookOrdersParams;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcoindeMarketDataServiceRaw
extends BitcoindeBaseService {
    private final SynchronizedValueFactory<Long> nonceFactory;

    public BitcoindeMarketDataServiceRaw(BitcoindeExchange exchange) {
        super(exchange);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public BitcoindeCompactOrderbookWrapper getBitcoindeCompactOrderBook(CurrencyPair currencyPair) throws IOException {
        try {
            return this.bitcoinde.getCompactOrderBook(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindePair(currencyPair));
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeOrderbookWrapper getBitcoindeOrderBook(CurrencyPair currencyPair, Order.OrderType type, BitcoindeOrderbookOrdersParams params) throws IOException {
        try {
            return this.bitcoinde.getOrderBook(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindePair(currencyPair), BitcoindeUtils.createBitcoindeType(type), BitcoindeUtils.createBitcoindeBoolean(params.onlyOrdersWithRequirementsFullfilled()), BitcoindeUtils.createBitcoindeBoolean(params.onlyFromFullyIdentifiedUsers()), BitcoindeUtils.createBitcoindeBoolean(params.onlyExpressOrders()));
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeTradesWrapper getBitcoindeTrades(CurrencyPair currencyPair, Integer since) throws IOException {
        try {
            return this.bitcoinde.getTrades(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindePair(currencyPair), since);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }
}

