/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.io.IOException;
import org.knowm.xchange.bitcoinde.v4.BitcoindeAdapters;
import org.knowm.xchange.bitcoinde.v4.BitcoindeExchange;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeMarketDataServiceRaw;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeOrderbookOrdersParams;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcoindeMarketDataService
extends BitcoindeMarketDataServiceRaw
implements MarketDataService {
    public BitcoindeMarketDataService(BitcoindeExchange exchange) {
        super(exchange);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args == null || args.length == 0) {
            return BitcoindeAdapters.adaptCompactOrderBook(this.getBitcoindeCompactOrderBook(currencyPair), currencyPair);
        }
        if (args[0] instanceof BitcoindeOrderbookOrdersParams) {
            BitcoindeOrderbookOrdersParams params = (BitcoindeOrderbookOrdersParams)args[0];
            return BitcoindeAdapters.adaptOrderBook(this.getBitcoindeOrderBook(currencyPair, Order.OrderType.BID, params), this.getBitcoindeOrderBook(currencyPair, Order.OrderType.ASK, params), currencyPair);
        }
        throw new IllegalArgumentException(String.format("Only support %s as an argument", BitcoindeOrderbookOrdersParams.class.getSimpleName()));
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        Integer since = null;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Integer) {
                since = (Integer)args[0];
            } else {
                throw new IllegalArgumentException("Extra argument #1,  'since', must be an int (was " + args[0].getClass() + ")");
            }
        }
        return BitcoindeAdapters.adaptTrades(this.getBitcoindeTrades(currencyPair, since), currencyPair);
    }
}

