/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.bitcoinde.BitcoindeUtils;
import org.knowm.xchange.bitcoinde.v4.BitcoindeExchange;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeAccountLedgerType;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeException;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountLedgerWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountWrapper;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeBaseService;
import org.knowm.xchange.currency.Currency;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcoindeAccountServiceRaw
extends BitcoindeBaseService {
    private final SynchronizedValueFactory<Long> nonceFactory;

    protected BitcoindeAccountServiceRaw(BitcoindeExchange exchange) {
        super(exchange);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public BitcoindeAccountWrapper getBitcoindeAccount() throws IOException {
        try {
            return this.bitcoinde.getAccount(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeAccountLedgerWrapper getAccountLedger(Currency currency, BitcoindeAccountLedgerType type, Date start, Date end, Integer page) throws IOException {
        String typeAsString = type != null ? type.getValue() : null;
        String startAsString = start != null ? BitcoindeUtils.rfc3339Timestamp(start) : null;
        String endAsString = end != null ? BitcoindeUtils.rfc3339Timestamp(end) : null;
        try {
            return this.bitcoinde.getAccountLedger(this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator, BitcoindeUtils.createBitcoindeCurrency(currency), typeAsString, startAsString, endAsString, page);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }
}

