/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.bitcoinde.v4.BitcoindeAdapters;
import org.knowm.xchange.bitcoinde.v4.BitcoindeExchange;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeAccountLedgerType;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountLedger;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountLedgerWrapper;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeAccountServiceRaw;
import org.knowm.xchange.bitcoinde.v4.service.BitcoindeFundingHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.utils.Assert;

public class BitcoindeAccountService
extends BitcoindeAccountServiceRaw
implements AccountService {
    public BitcoindeAccountService(BitcoindeExchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return BitcoindeAdapters.adaptAccountInfo(this.getBitcoindeAccount());
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BitcoindeFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        Assert.isTrue((boolean)(params instanceof TradeHistoryParamCurrency), (String)"You need to provide a currency to retrieve the funding history.");
        if (((TradeHistoryParamCurrency)params).getCurrency() == null) {
            throw new IllegalArgumentException("Currency has to be specified");
        }
        if (params instanceof BitcoindeFundingHistoryParams && ((BitcoindeFundingHistoryParams)params).getType() != null && ((BitcoindeFundingHistoryParams)params).getCustomType() != null) {
            throw new IllegalArgumentException("Only one type can be specified");
        }
        Currency currency = ((TradeHistoryParamCurrency)params).getCurrency();
        BitcoindeAccountLedgerType customType = null;
        boolean leaveFeesSeperate = false;
        Date start = null;
        Date end = null;
        Integer pageNumber = null;
        if (params instanceof HistoryParamsFundingType && ((HistoryParamsFundingType)params).getType() != null) {
            switch (((HistoryParamsFundingType)params).getType()) {
                case WITHDRAWAL: {
                    customType = BitcoindeAccountLedgerType.PAYOUT;
                    break;
                }
                case DEPOSIT: {
                    customType = BitcoindeAccountLedgerType.INPAYMENT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported FundingRecord.Type: " + ((HistoryParamsFundingType)params).getType() + ". For Bitcoin.de specific types use BitcoindeFundingHistoryParams#customType");
                }
            }
        }
        if (params instanceof BitcoindeFundingHistoryParams) {
            customType = ((BitcoindeFundingHistoryParams)params).getCustomType();
            leaveFeesSeperate = ((BitcoindeFundingHistoryParams)params).isLeaveFeesSeperate();
        }
        if (params instanceof TradeHistoryParamsTimeSpan) {
            start = ((TradeHistoryParamsTimeSpan)params).getStartTime();
            end = ((TradeHistoryParamsTimeSpan)params).getEndTime();
        }
        if (params instanceof TradeHistoryParamPaging) {
            pageNumber = ((TradeHistoryParamPaging)params).getPageNumber();
        }
        BitcoindeAccountLedgerWrapper result = this.getAccountLedger(currency, customType, start, end, pageNumber);
        List<BitcoindeAccountLedger> ledger = result.getAccountLedgers();
        if (!leaveFeesSeperate && !ledger.isEmpty()) {
            ledger.addAll(this.checkForAndQueryAdditionalFees(ledger, currency, customType, start, end, pageNumber));
        }
        if (params instanceof BitcoindeFundingHistoryParams) {
            ((BitcoindeFundingHistoryParams)params).setPageNumber(result.getPage().getCurrent());
            ((BitcoindeFundingHistoryParams)params).setLastPageNumber(result.getPage().getLast());
        }
        return BitcoindeAdapters.adaptFundingHistory(currency, ledger, leaveFeesSeperate);
    }

    private List<BitcoindeAccountLedger> checkForAndQueryAdditionalFees(List<BitcoindeAccountLedger> ledgers, Currency currency, BitcoindeAccountLedgerType customType, Date start, Date end, Integer page) throws IOException {
        if (customType != null && BitcoindeAccountLedgerType.PAYOUT != customType && BitcoindeAccountLedgerType.ALL != customType) {
            return Collections.emptyList();
        }
        if (BitcoindeAccountLedgerType.PAYOUT == customType) {
            return this.getAccountLedger(currency, BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY, start, end, page).getAccountLedgers();
        }
        int feeCount = 0;
        for (int i = ledgers.size() - 1; i >= 0; --i) {
            if (BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY == ledgers.get(i).getType()) {
                ++feeCount;
                continue;
            }
            if (BitcoindeAccountLedgerType.PAYOUT != ledgers.get(i).getType()) break;
            --feeCount;
        }
        if (feeCount < 0) {
            ArrayList<BitcoindeAccountLedger> feeLedgers = new ArrayList<BitcoindeAccountLedger>();
            List<BitcoindeAccountLedger> feeResult = this.getAccountLedger(currency, customType, start, end, page + 1).getAccountLedgers();
            for (BitcoindeAccountLedger ledger : feeResult) {
                if (BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY != ledger.getType()) break;
                feeLedgers.add(ledger);
            }
            return feeLedgers;
        }
        return Collections.emptyList();
    }
}

