/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeError;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeMaintenance;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeResponse;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeTrade;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class BitcoindeTradesWrapper
extends BitcoindeResponse {
    private final CurrencyPair tradingPair;
    private final BitcoindeTrade[] trades;

    @JsonCreator
    public BitcoindeTradesWrapper(@JsonProperty(value="trading_pair") @JsonDeserialize(using=CurrencyPairDeserializer.class) CurrencyPair tradingPair, @JsonProperty(value="trades") BitcoindeTrade[] trades, @JsonProperty(value="credits") Integer credits, @JsonProperty(value="errors") BitcoindeError[] errors, @JsonProperty(value="maintenance") BitcoindeMaintenance maintenance, @JsonProperty(value="nonce") Long nonce) {
        super(credits, errors, maintenance, nonce);
        this.tradingPair = tradingPair;
        this.trades = trades;
    }

    public CurrencyPair getTradingPair() {
        return this.tradingPair;
    }

    public BitcoindeTrade[] getTrades() {
        return this.trades;
    }

    @Override
    public String toString() {
        return "BitcoindeTradesWrapper(tradingPair=" + this.getTradingPair() + ", trades=" + Arrays.deepToString(this.getTrades()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoindeTradesWrapper)) {
            return false;
        }
        BitcoindeTradesWrapper other = (BitcoindeTradesWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CurrencyPair this$tradingPair = this.getTradingPair();
        CurrencyPair other$tradingPair = other.getTradingPair();
        if (this$tradingPair == null ? other$tradingPair != null : !this$tradingPair.equals(other$tradingPair)) {
            return false;
        }
        return Arrays.deepEquals(this.getTrades(), other.getTrades());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BitcoindeTradesWrapper;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CurrencyPair $tradingPair = this.getTradingPair();
        result = result * 59 + ($tradingPair == null ? 43 : $tradingPair.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTrades());
        return result;
    }
}

