/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeError;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeMaintenance;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class BitcoindeException
extends RuntimeException {
    private final Integer credits;
    private final BitcoindeError[] errors;
    private final BitcoindeMaintenance maintenance;
    private final Long nonce;

    @JsonCreator
    public BitcoindeException(@JsonProperty(value="credits") Integer credits, @JsonProperty(value="errors") BitcoindeError[] errors, @JsonProperty(value="maintenance") BitcoindeMaintenance maintenance, @JsonProperty(value="nonce") Long nonce) {
        this.credits = credits;
        this.errors = errors;
        this.maintenance = maintenance;
        this.nonce = nonce;
    }

    @Override
    public String getMessage() {
        return Arrays.stream(this.errors).map(BitcoindeError::toString).collect(Collectors.joining(", "));
    }

    public Integer getCredits() {
        return this.credits;
    }

    public BitcoindeError[] getErrors() {
        return this.errors;
    }

    public BitcoindeMaintenance getMaintenance() {
        return this.maintenance;
    }

    public Long getNonce() {
        return this.nonce;
    }

    @Override
    public String toString() {
        return "BitcoindeException(credits=" + this.getCredits() + ", errors=" + Arrays.deepToString(this.getErrors()) + ", maintenance=" + this.getMaintenance() + ", nonce=" + this.getNonce() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoindeException)) {
            return false;
        }
        BitcoindeException other = (BitcoindeException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$credits = this.getCredits();
        Integer other$credits = other.getCredits();
        if (this$credits == null ? other$credits != null : !((Object)this$credits).equals(other$credits)) {
            return false;
        }
        Long this$nonce = this.getNonce();
        Long other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getErrors(), other.getErrors())) {
            return false;
        }
        BitcoindeMaintenance this$maintenance = this.getMaintenance();
        BitcoindeMaintenance other$maintenance = other.getMaintenance();
        return !(this$maintenance == null ? other$maintenance != null : !((Object)this$maintenance).equals(other$maintenance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitcoindeException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $credits = this.getCredits();
        result = result * 59 + ($credits == null ? 43 : ((Object)$credits).hashCode());
        Long $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getErrors());
        BitcoindeMaintenance $maintenance = this.getMaintenance();
        result = result * 59 + ($maintenance == null ? 43 : ((Object)$maintenance).hashCode());
        return result;
    }
}

