/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeError;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.RateLimitExceededException;

public final class BitcoindeErrorAdapter {
    private static final List<ExceptionTranslation> TRANSLATIONS = new LinkedList<ExceptionTranslation>();

    private BitcoindeErrorAdapter() {
    }

    public static RuntimeException adaptBitcoindeException(BitcoindeException exception) {
        for (ExceptionTranslation translation : TRANSLATIONS) {
            Optional<BitcoindeError> error = BitcoindeErrorAdapter.getErrorCode(exception.getErrors(), translation.getErrorCodes());
            if (!error.isPresent()) continue;
            return translation.provider.provide(error.get(), exception);
        }
        return new ExchangeException(exception.getMessage(), (Throwable)exception);
    }

    private static Optional<BitcoindeError> getErrorCode(BitcoindeError[] errors, int[] errorCodes) {
        return Arrays.stream(errors).filter(error -> Arrays.stream(errorCodes).anyMatch(errorCode -> error.getCode() == errorCode)).findFirst();
    }

    static {
        TRANSLATIONS.add(new ExceptionTranslation((error, exception) -> new NonceException(error.toString() + ", Last Nonce: " + exception.getNonce()), 4));
        TRANSLATIONS.add(new ExceptionTranslation((error, exception) -> new RateLimitExceededException(error.toString() + ", Credits: " + exception.getCredits()), 6));
        TRANSLATIONS.add(new ExceptionTranslation((error, exception) -> new ExchangeSecurityException(error.toString()), 2, 3, 5, 9, 10, 11, 14, 32, 33, 94));
        TRANSLATIONS.add(new ExceptionTranslation((error, exception) -> new NotAvailableFromExchangeException(error.toString()), 7, 8));
    }

    private static final class ExceptionTranslation {
        private final ExceptionProvider provider;
        private final int[] errorCodes;

        public ExceptionTranslation(ExceptionProvider provider, int ... errorCodes) {
            this.provider = provider;
            this.errorCodes = errorCodes;
        }

        public ExceptionProvider getProvider() {
            return this.provider;
        }

        public int[] getErrorCodes() {
            return this.errorCodes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionTranslation)) {
                return false;
            }
            ExceptionTranslation other = (ExceptionTranslation)o;
            ExceptionProvider this$provider = this.getProvider();
            ExceptionProvider other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            return Arrays.equals(this.getErrorCodes(), other.getErrorCodes());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExceptionProvider $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            result = result * 59 + Arrays.hashCode(this.getErrorCodes());
            return result;
        }

        public String toString() {
            return "BitcoindeErrorAdapter.ExceptionTranslation(provider=" + this.getProvider() + ", errorCodes=" + Arrays.toString(this.getErrorCodes()) + ")";
        }
    }

    @FunctionalInterface
    private static interface ExceptionProvider {
        public RuntimeException provide(BitcoindeError var1, BitcoindeException var2);
    }
}

