/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeAccountLedgerType;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderFlagsOrderQuantities;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderFlagsOrderRequirements;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderFlagsTradingPartnerInformation;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderRequirements;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderState;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeType;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountLedger;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAllocation;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeBalance;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeCompactOrder;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeCompactOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeOrder;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeTrade;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeTradesWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyOrder;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyOrdersWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyTrade;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyTradesWrapper;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;

public final class BitcoindeAdapters {
    private BitcoindeAdapters() {
    }

    public static OrderBook adaptCompactOrderBook(BitcoindeCompactOrderbookWrapper bitcoindeOrderbookWrapper, CurrencyPair currencyPair) {
        List<LimitOrder> asks = BitcoindeAdapters.createCompactOrders(currencyPair, Order.OrderType.ASK, bitcoindeOrderbookWrapper.getBitcoindeOrders().getAsks());
        List<LimitOrder> bids = BitcoindeAdapters.createCompactOrders(currencyPair, Order.OrderType.BID, bitcoindeOrderbookWrapper.getBitcoindeOrders().getBids());
        Collections.sort(asks);
        Collections.sort(bids);
        return new OrderBook(null, asks, bids);
    }

    public static OrderBook adaptOrderBook(BitcoindeOrderbookWrapper asksWrapper, BitcoindeOrderbookWrapper bidsWrapper, CurrencyPair currencyPair) {
        List<LimitOrder> asks = BitcoindeAdapters.createOrders(currencyPair, Order.OrderType.ASK, asksWrapper.getBitcoindeOrders());
        List<LimitOrder> bids = BitcoindeAdapters.createOrders(currencyPair, Order.OrderType.BID, bidsWrapper.getBitcoindeOrders());
        Collections.sort(asks);
        Collections.sort(bids);
        return new OrderBook(null, asks, bids);
    }

    public static List<LimitOrder> createCompactOrders(CurrencyPair currencyPair, Order.OrderType orderType, BitcoindeCompactOrder[] orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BitcoindeCompactOrder order : orders) {
            limitOrders.add(new LimitOrder(orderType, order.getAmount(), (Instrument)currencyPair, null, null, order.getPrice()));
        }
        return limitOrders;
    }

    private static List<LimitOrder> createOrders(CurrencyPair currencyPair, Order.OrderType orderType, BitcoindeOrder[] orders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BitcoindeOrder order : orders) {
            limitOrders.add(BitcoindeAdapters.createOrder(currencyPair, order, orderType, order.getOrderId(), null));
        }
        return limitOrders;
    }

    public static LimitOrder createOrder(CurrencyPair currencyPair, BitcoindeOrder bitcoindeOrder, Order.OrderType orderType, String orderId, Date timeStamp) {
        LimitOrder.Builder limitOrder = new LimitOrder.Builder(orderType, (Instrument)currencyPair).id(orderId).timestamp(timeStamp).originalAmount(bitcoindeOrder.getMaxAmount()).limitPrice(bitcoindeOrder.getPrice()).orderStatus(Order.OrderStatus.NEW);
        limitOrder.flag((Order.IOrderFlags)new BitcoindeOrderFlagsOrderQuantities(bitcoindeOrder.getMinAmount(), bitcoindeOrder.getMaxAmount(), bitcoindeOrder.getMinVolume(), bitcoindeOrder.getMaxVolume()));
        if (bitcoindeOrder.getTradingPartnerInformation() != null) {
            BitcoindeOrderFlagsTradingPartnerInformation tpi = new BitcoindeOrderFlagsTradingPartnerInformation(bitcoindeOrder.getTradingPartnerInformation().getUserName(), bitcoindeOrder.getTradingPartnerInformation().getKycFull(), bitcoindeOrder.getTradingPartnerInformation().getTrustLevel());
            tpi.setBankName(bitcoindeOrder.getTradingPartnerInformation().getBankName());
            tpi.setBic(bitcoindeOrder.getTradingPartnerInformation().getBic());
            tpi.setSeatOfBank(bitcoindeOrder.getTradingPartnerInformation().getSeatOfBank());
            tpi.setRating(bitcoindeOrder.getTradingPartnerInformation().getRating());
            tpi.setNumberOfTrades(bitcoindeOrder.getTradingPartnerInformation().getAmountTrades());
            limitOrder.flag((Order.IOrderFlags)tpi);
        }
        if (bitcoindeOrder.getOrderRequirements() != null) {
            limitOrder.flag((Order.IOrderFlags)BitcoindeAdapters.adaptOrderRequirements(bitcoindeOrder.getOrderRequirements()));
        }
        return limitOrder.build();
    }

    private static BitcoindeOrderFlagsOrderRequirements adaptOrderRequirements(BitcoindeOrderRequirements requirements) {
        return new BitcoindeOrderFlagsOrderRequirements(requirements.getMinTrustLevel(), requirements.getOnlyKycFull(), requirements.getSeatOfBank(), requirements.getPaymentOption());
    }

    public static Trades adaptTrades(BitcoindeTradesWrapper bitcoindeTradesWrapper, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (BitcoindeTrade bitcoindeTrade : bitcoindeTradesWrapper.getTrades()) {
            long tid = bitcoindeTrade.getTid();
            if (tid > lastTradeId) {
                lastTradeId = tid;
            }
            trades.add(new Trade.Builder().originalAmount(bitcoindeTrade.getAmount()).currencyPair(currencyPair).price(bitcoindeTrade.getPrice()).timestamp(bitcoindeTrade.getDate()).id(String.valueOf(tid)).build());
        }
        return new Trades(trades, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static AccountInfo adaptAccountInfo(BitcoindeAccountWrapper bitcoindeAccount) {
        boolean hasBalances = bitcoindeAccount.getData().getBalances() != null && bitcoindeAccount.getData().getBalances().size() > 0;
        boolean hasAllocations = bitcoindeAccount.getData().getFidorReservation() != null && bitcoindeAccount.getData().getFidorReservation().getAllocation() != null && bitcoindeAccount.getData().getFidorReservation().getAllocation().size() > 0;
        Map<Object, Object> bitcoindeBalances = hasBalances ? bitcoindeAccount.getData().getBalances() : new HashMap();
        Map<Object, Object> fidorAllocations = hasAllocations ? bitcoindeAccount.getData().getFidorReservation().getAllocation() : new HashMap();
        HashSet<Object> currencyStrings = new HashSet<Object>();
        currencyStrings.addAll(bitcoindeBalances.keySet());
        currencyStrings.addAll(fidorAllocations.keySet());
        List wallets = currencyStrings.stream().map(currencyString -> {
            Currency currency = Currency.getInstance((String)currencyString);
            LinkedList<Balance> balances = new LinkedList<Balance>();
            if (bitcoindeBalances.containsKey(currencyString)) {
                BitcoindeBalance balance = (BitcoindeBalance)bitcoindeBalances.get(currencyString);
                balances.add(new Balance(Currency.getInstance((String)currencyString), balance.getTotalAmount(), balance.getAvailableAmount(), balance.getReservedAmount()));
            }
            if (fidorAllocations.containsKey(currencyString)) {
                BitcoindeAllocation allocation = (BitcoindeAllocation)fidorAllocations.get(currencyString);
                balances.add(new Balance(Currency.EUR, allocation.getMaxEurVolume(), allocation.getMaxEurVolume().subtract(allocation.getEurVolumeOpenOrders())));
            }
            return Wallet.Builder.from(balances).id(currency.getCurrencyCode()).build();
        }).collect(Collectors.toList());
        return new AccountInfo(wallets);
    }

    public static List<FundingRecord> adaptFundingHistory(Currency currency, List<BitcoindeAccountLedger> accountLedgers, boolean leaveFeesSeperate) {
        List feeLedgers = accountLedgers.stream().filter(ledger -> !leaveFeesSeperate && BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY == ledger.getType()).collect(Collectors.toList());
        return accountLedgers.stream().filter(ledger -> BitcoindeAccountLedgerType.SELL != ledger.getType() && BitcoindeAccountLedgerType.BUY != ledger.getType()).filter(ledger -> leaveFeesSeperate || BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY != ledger.getType()).map(ledger -> {
            Optional<BitcoindeAccountLedger> feeLedger;
            FundingRecord.Type type = BitcoindeAdapters.adaptFundingRecordType(ledger.getType());
            FundingRecord.Builder builder = new FundingRecord.Builder().setType(type).setDate(ledger.getDate()).setCurrency(currency).setAmount(ledger.getCashflow().abs()).setBalance(ledger.getBalance()).setStatus(FundingRecord.Status.COMPLETE).setDescription(ledger.getType().getValue());
            if (BitcoindeAccountLedgerType.INPAYMENT == ledger.getType() || BitcoindeAccountLedgerType.PAYOUT == ledger.getType()) {
                builder.setBlockchainTransactionHash(ledger.getReference());
            } else {
                builder.setInternalId(ledger.getReference());
            }
            if (!leaveFeesSeperate && BitcoindeAccountLedgerType.PAYOUT == ledger.getType() && (feeLedger = BitcoindeAdapters.findFeeLedger(ledger.getReference(), feeLedgers)).isPresent()) {
                BigDecimal fee = feeLedger.get().getCashflow().abs();
                builder.setAmount(ledger.getCashflow().abs().add(fee));
                builder.setFee(fee);
                feeLedgers.remove(feeLedger.get());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private static Optional<BitcoindeAccountLedger> findFeeLedger(String reference, List<BitcoindeAccountLedger> feeLedgers) {
        return feeLedgers.stream().filter(ledger -> BitcoindeAccountLedgerType.OUTGOING_FEE_VOLUNTARY == ledger.getType() && reference.equals(ledger.getReference())).findFirst();
    }

    public static FundingRecord.Type adaptFundingRecordType(BitcoindeAccountLedgerType type) {
        switch (type) {
            case INPAYMENT: {
                return FundingRecord.Type.DEPOSIT;
            }
            case PAYOUT: {
                return FundingRecord.Type.WITHDRAWAL;
            }
            case WELCOME_BTC: {
                return FundingRecord.Type.AIRDROP;
            }
            case AFFILIATE: 
            case KICKBACK: {
                return FundingRecord.Type.OTHER_INFLOW;
            }
            case BUY_YUBIKEY: 
            case BUY_GOLDSHOP: 
            case BUY_DIAMONDSHOP: {
                return FundingRecord.Type.OTHER_OUTFLOW;
            }
        }
        throw new IllegalArgumentException("Can't adapt \"" + (Object)((Object)type) + "\" to FundingRecord.Type");
    }

    public static UserTrades adaptTradeHistory(BitcoindeMyTradesWrapper bitcoindeMyTradesWrapper) {
        return BitcoindeAdapters.adaptTradeHistory(bitcoindeMyTradesWrapper, Trades.TradeSortType.SortByTimestamp);
    }

    public static UserTrades adaptTradeHistory(BitcoindeMyTradesWrapper bitcoindeMyTradesWrapper, Trades.TradeSortType sortType) {
        List<BitcoindeMyTrade> trades = bitcoindeMyTradesWrapper.getTrades();
        ArrayList<UserTrade> result = new ArrayList<UserTrade>(trades.size());
        for (BitcoindeMyTrade trade : trades) {
            Currency feeCurrency;
            BigDecimal fee;
            if (trade.getType() == BitcoindeType.BUY) {
                fee = trade.getFeeCurrencyToTrade();
                feeCurrency = trade.getTradingPair().base;
            } else if (trade.getType() == BitcoindeType.SELL) {
                fee = trade.getFeeCurrencyToPay();
                feeCurrency = trade.getTradingPair().counter;
            } else {
                throw new TypeNotPresentException(trade.getType().toString(), null);
            }
            Date timestamp = trade.getSuccessfullyFinishedAt() != null ? trade.getSuccessfullyFinishedAt() : trade.getCreatedAt();
            result.add(UserTrade.builder().id(trade.getTradeId()).timestamp(timestamp).currencyPair(trade.getTradingPair()).type(BitcoindeAdapters.adaptOrderType(trade.getType())).originalAmount(trade.getAmountCurrencyToTrade()).price(trade.getPrice()).feeAmount(fee).feeCurrency(feeCurrency).build());
        }
        return new UserTrades(result, sortType);
    }

    public static OpenOrders adaptOpenOrders(BitcoindeMyOrdersWrapper bitcoindeOpenOrdersWrapper) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>();
        for (BitcoindeMyOrder bitcoindeMyOrder : bitcoindeOpenOrdersWrapper.getOrders()) {
            LimitOrder limitOrder = new LimitOrder.Builder(BitcoindeAdapters.adaptOrderType(bitcoindeMyOrder.getType()), (Instrument)bitcoindeMyOrder.getTradingPair()).id(bitcoindeMyOrder.getOrderId()).timestamp(bitcoindeMyOrder.getCreatedAt()).originalAmount(bitcoindeMyOrder.getMaxAmount()).limitPrice(bitcoindeMyOrder.getPrice()).orderStatus(BitcoindeAdapters.adaptOrderStatus(bitcoindeMyOrder.getState())).flag((Order.IOrderFlags)new BitcoindeOrderFlagsOrderQuantities(bitcoindeMyOrder.getMinAmount(), bitcoindeMyOrder.getMaxAmount(), bitcoindeMyOrder.getMinVolume(), bitcoindeMyOrder.getMaxVolume())).flag((Order.IOrderFlags)BitcoindeAdapters.adaptOrderRequirements(bitcoindeMyOrder.getOrderRequirements())).build();
            orders.add(limitOrder);
        }
        return new OpenOrders(orders);
    }

    public static Order.OrderType adaptOrderType(BitcoindeType type) {
        return type == BitcoindeType.BUY ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static Order.OrderStatus adaptOrderStatus(BitcoindeOrderState state) {
        switch (state) {
            case EXPIRED: {
                return Order.OrderStatus.EXPIRED;
            }
            case CANCELLED: {
                return Order.OrderStatus.CANCELED;
            }
        }
        return Order.OrderStatus.NEW;
    }
}

