/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.util.Date;
import org.knowm.xchange.bitcoinde.v4.BitcoindeAdapters;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeOrderState;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeType;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamOffset;

public class BitcoindeOpenOrdersParams
implements OpenOrdersParamCurrencyPair,
OpenOrdersParamOffset {
    private CurrencyPair currencyPair;
    private BitcoindeType type;
    private BitcoindeOrderState state;
    private Date start;
    private Date end;
    private Integer offset;

    public BitcoindeOpenOrdersParams(BitcoindeOrderState state) {
        this.state = state;
    }

    public boolean accept(LimitOrder order) {
        return this.accept((Order)order);
    }

    public boolean accept(Order order) {
        return order != null && order.getInstrument().equals(this.currencyPair) && order.getType() == BitcoindeAdapters.adaptOrderType(this.type) && order.getStatus() == BitcoindeAdapters.adaptOrderStatus(this.state) && !order.getTimestamp().before(this.start) && !order.getTimestamp().after(this.end);
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public BitcoindeType getType() {
        return this.type;
    }

    public BitcoindeOrderState getState() {
        return this.state;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setCurrencyPair(CurrencyPair currencyPair) {
        this.currencyPair = currencyPair;
    }

    public void setType(BitcoindeType type) {
        this.type = type;
    }

    public void setState(BitcoindeOrderState state) {
        this.state = state;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoindeOpenOrdersParams)) {
            return false;
        }
        BitcoindeOpenOrdersParams other = (BitcoindeOpenOrdersParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        CurrencyPair this$currencyPair = this.getCurrencyPair();
        CurrencyPair other$currencyPair = other.getCurrencyPair();
        if (this$currencyPair == null ? other$currencyPair != null : !this$currencyPair.equals(other$currencyPair)) {
            return false;
        }
        BitcoindeType this$type = this.getType();
        BitcoindeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        BitcoindeOrderState this$state = this.getState();
        BitcoindeOrderState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Date this$end = this.getEnd();
        Date other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitcoindeOpenOrdersParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        CurrencyPair $currencyPair = this.getCurrencyPair();
        result = result * 59 + ($currencyPair == null ? 43 : $currencyPair.hashCode());
        BitcoindeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        BitcoindeOrderState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Date $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    public String toString() {
        return "BitcoindeOpenOrdersParams(currencyPair=" + this.getCurrencyPair() + ", type=" + (Object)((Object)this.getType()) + ", state=" + (Object)((Object)this.getState()) + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", offset=" + this.getOffset() + ")";
    }

    public BitcoindeOpenOrdersParams() {
    }

    public BitcoindeOpenOrdersParams(CurrencyPair currencyPair, BitcoindeType type, BitcoindeOrderState state, Date start, Date end, Integer offset) {
        this.currencyPair = currencyPair;
        this.type = type;
        this.state = state;
        this.start = start;
        this.end = end;
        this.offset = offset;
    }
}

