/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4.service;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class BitcoindeDigest
extends BaseParamsDigest {
    private final String apiKey;

    private BitcoindeDigest(String secretKeyBase64, String apiKey) {
        super(secretKeyBase64, "HmacSHA256");
        this.apiKey = apiKey;
    }

    public static BitcoindeDigest createInstance(String secretKeyBase64, String apiKey) {
        return secretKeyBase64 == null ? null : new BitcoindeDigest(secretKeyBase64, apiKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        String completeURL = restInvocation.getInvocationUrl();
        String httpMethod = restInvocation.getHttpMethod();
        String requestBody = restInvocation.getRequestBody();
        String md5 = "POST".equals(httpMethod) ? this.getMD5(requestBody) : "d41d8cd98f00b204e9800998ecf8427e";
        String nonce = (String)restInvocation.getHttpHeadersFromParams().get("X-API-NONCE");
        String hmac_data = String.format("%s#%s#%s#%s#%s", httpMethod, completeURL, this.apiKey, nonce, md5);
        Mac mac256 = this.getMac();
        mac256.update(hmac_data.getBytes());
        return String.format("%064x", new BigInteger(1, mac256.doFinal()));
    }

    private String getMD5(String original) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(original.getBytes());
        byte[] digest = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

