/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.v4;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeException;
import org.knowm.xchange.bitcoinde.v4.dto.BitcoindeResponse;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountLedgerWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.account.BitcoindeAccountWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeCompactOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeOrderbookWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.marketdata.BitcoindeTradesWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeIdResponse;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyOrdersWrapper;
import org.knowm.xchange.bitcoinde.v4.dto.trade.BitcoindeMyTradesWrapper;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v4")
@Produces(value={"application/json"})
public interface Bitcoinde {
    @GET
    @Path(value="{trading_pair}/orderbook/compact")
    public BitcoindeCompactOrderbookWrapper getCompactOrderBook(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="trading_pair") String var4) throws IOException, BitcoindeException;

    @GET
    @Path(value="{trading_pair}/orderbook")
    public BitcoindeOrderbookWrapper getOrderBook(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="trading_pair") String var4, @QueryParam(value="type") String var5, @QueryParam(value="order_requirements_fullfilled") Integer var6, @QueryParam(value="only_kyc_full") Integer var7, @QueryParam(value="only_express_orders") Integer var8) throws IOException, BitcoindeException;

    @GET
    @Path(value="{trading_pair}/trades/history")
    public BitcoindeTradesWrapper getTrades(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="trading_pair") String var4, @QueryParam(value="since_tid") Integer var5) throws IOException, BitcoindeException;

    @GET
    @Path(value="account")
    public BitcoindeAccountWrapper getAccount(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3) throws IOException, BitcoindeException;

    @GET
    @Path(value="{currency}/account/ledger")
    public BitcoindeAccountLedgerWrapper getAccountLedger(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="currency") String var4, @QueryParam(value="type") String var5, @QueryParam(value="datetime_start") String var6, @QueryParam(value="datetime_end") String var7, @QueryParam(value="page") Integer var8) throws IOException, BitcoindeException;

    @GET
    @Path(value="orders")
    public BitcoindeMyOrdersWrapper getMyOrders(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @QueryParam(value="type") String var4, @QueryParam(value="state") Integer var5, @QueryParam(value="date_start") String var6, @QueryParam(value="date_end") String var7, @QueryParam(value="page") Integer var8) throws IOException, BitcoindeException;

    @GET
    @Path(value="{trading_pair}/orders")
    public BitcoindeMyOrdersWrapper getMyOrders(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="trading_pair") String var4, @QueryParam(value="type") String var5, @QueryParam(value="state") Integer var6, @QueryParam(value="date_start") String var7, @QueryParam(value="date_end") String var8, @QueryParam(value="page") Integer var9) throws IOException, BitcoindeException;

    @POST
    @Path(value="{trading_pair}/orders")
    public BitcoindeIdResponse createOrder(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @FormParam(value="max_amount_currency_to_trade") BigDecimal var4, @FormParam(value="price") BigDecimal var5, @PathParam(value="trading_pair") String var6, @FormParam(value="type") String var7) throws IOException, BitcoindeException;

    @DELETE
    @Path(value="{trading_pair}/orders/{order_id}")
    public BitcoindeResponse deleteOrder(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="order_id") String var4, @PathParam(value="trading_pair") String var5) throws IOException, BitcoindeException;

    @GET
    @Path(value="trades")
    public BitcoindeMyTradesWrapper getMyTrades(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @QueryParam(value="type") String var4, @QueryParam(value="state") Integer var5, @QueryParam(value="only_trades_with_action_for_payment_or_transfer_required") Integer var6, @QueryParam(value="payment_method") Integer var7, @QueryParam(value="date_start") String var8, @QueryParam(value="date_end") String var9, @QueryParam(value="page") Integer var10) throws IOException, BitcoindeException;

    @GET
    @Path(value="{trading_pair}/trades")
    public BitcoindeMyTradesWrapper getMyTrades(@HeaderParam(value="X-API-KEY") String var1, @HeaderParam(value="X-API-NONCE") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-API-SIGNATURE") ParamsDigest var3, @PathParam(value="trading_pair") String var4, @QueryParam(value="type") String var5, @QueryParam(value="state") Integer var6, @QueryParam(value="only_trades_with_action_for_payment_or_transfer_required") Integer var7, @QueryParam(value="payment_method") Integer var8, @QueryParam(value="date_start") String var9, @QueryParam(value="date_end") String var10, @QueryParam(value="page") Integer var11) throws IOException, BitcoindeException;
}

