/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitcoinde.BitcoindeUtils;
import org.knowm.xchange.bitcoinde.dto.BitcoindeException;
import org.knowm.xchange.bitcoinde.dto.marketdata.BitcoindeOrderbookWrapper;
import org.knowm.xchange.bitcoinde.dto.marketdata.BitcoindeTradesWrapper;
import org.knowm.xchange.bitcoinde.service.BitcoindeBaseService;
import org.knowm.xchange.currency.CurrencyPair;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcoindeMarketDataServiceRaw
extends BitcoindeBaseService {
    private final SynchronizedValueFactory<Long> nonceFactory;

    public BitcoindeMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
        this.nonceFactory = exchange.getNonceFactory();
    }

    public BitcoindeOrderbookWrapper getBitcoindeOrderBook(CurrencyPair currencyPair) throws IOException {
        try {
            return this.bitcoinde.getOrderBook(BitcoindeUtils.createBitcoindePair(currencyPair), this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }

    public BitcoindeTradesWrapper getBitcoindeTrades(CurrencyPair currencyPair, Integer since) throws IOException {
        try {
            return this.bitcoinde.getTrades(BitcoindeUtils.createBitcoindePair(currencyPair), since, this.apiKey, this.nonceFactory, (ParamsDigest)this.signatureCreator);
        }
        catch (BitcoindeException e) {
            throw this.handleError(e);
        }
    }
}

