/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoinde.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class BitcoindeOrderBook {
    private final BigDecimal[][] asks;
    private final BigDecimal[][] bids;
    private final Date timeStamp = null;

    public BitcoindeOrderBook(@JsonProperty(value="asks") BigDecimal[][] asks, @JsonProperty(value="bids") BigDecimal[][] bids) {
        this.asks = asks;
        this.bids = bids;
        Arrays.sort(this.asks, new Comparator<BigDecimal[]>(){

            @Override
            public int compare(BigDecimal[] entry1, BigDecimal[] entry2) {
                BigDecimal price1 = entry1[0];
                BigDecimal price2 = entry2[0];
                return price1.compareTo(price2);
            }
        });
        Arrays.sort(this.bids, new Comparator<BigDecimal[]>(){

            @Override
            public int compare(BigDecimal[] entry1, BigDecimal[] entry2) {
                BigDecimal price1 = entry1[0];
                BigDecimal price2 = entry2[0];
                return -1 * price1.compareTo(price2);
            }
        });
    }

    public BigDecimal[][] getAsks() {
        return this.asks;
    }

    public BigDecimal[][] getBids() {
        return this.bids;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String toString() {
        StringBuilder asksBuilder = new StringBuilder();
        StringBuilder bidsBuilder = new StringBuilder();
        for (Object[] objectArray : this.getAsks()) {
            asksBuilder.append(Arrays.toString(objectArray) + ";");
        }
        for (Object[] objectArray : this.getBids()) {
            bidsBuilder.append(Arrays.toString(objectArray) + ";");
        }
        return "BitcoindeOrderBook{asks=" + asksBuilder + ", bids=" + bidsBuilder + '}';
    }
}

