/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoincharts.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoincharts.BitcoinCharts;
import org.knowm.xchange.bitcoincharts.BitcoinChartsAdapters;
import org.knowm.xchange.bitcoincharts.dto.marketdata.BitcoinChartsTicker;
import org.knowm.xchange.bitcoincharts.service.BitcoinChartsBaseService;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcoinChartsMarketDataService
extends BitcoinChartsBaseService
implements MarketDataService {
    private final BitcoinCharts bitcoinCharts;

    public BitcoinChartsMarketDataService(Exchange exchange) {
        super(exchange);
        this.bitcoinCharts = (BitcoinCharts)ExchangeRestProxyBuilder.forInterface(BitcoinCharts.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        BitcoinChartsTicker[] bitcoinChartsTickers = this.getBitcoinChartsTickers();
        return BitcoinChartsAdapters.adaptTicker(bitcoinChartsTickers, currencyPair);
    }

    public BitcoinChartsTicker[] getBitcoinChartsTickers() throws IOException {
        return this.bitcoinCharts.getMarketData();
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        throw new NotAvailableFromExchangeException();
    }
}

