/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bitcoincharts;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bitcoincharts.BitcoinChartsAdapters;
import org.knowm.xchange.bitcoincharts.dto.marketdata.BitcoinChartsTicker;
import org.knowm.xchange.bitcoincharts.service.BitcoinChartsMarketDataService;
import org.knowm.xchange.exceptions.ExchangeException;
import si.mazi.rescu.SynchronizedValueFactory;

public class BitcoinChartsExchange
extends BaseExchange
implements Exchange {
    protected void initServices() {
        this.marketDataService = new BitcoinChartsMarketDataService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setPlainTextUri("http://api.bitcoincharts.com");
        exchangeSpecification.setHost("api.bitcoincharts.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("BitcoinCharts");
        exchangeSpecification.setExchangeDescription("Bitcoin charts provides financial and technical data related to the Bitcoin network.");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return null;
    }

    public void remoteInit() throws IOException, ExchangeException {
        BitcoinChartsTicker[] tickers = ((BitcoinChartsMarketDataService)this.marketDataService).getBitcoinChartsTickers();
        this.exchangeMetaData = BitcoinChartsAdapters.adaptMetaData(this.exchangeMetaData, tickers);
    }
}

