/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.instrument.Instrument;

public final class BinanceTicker24h {
    private final BigDecimal priceChange;
    private final BigDecimal priceChangePercent;
    private final BigDecimal weightedAvgPrice;
    private final BigDecimal prevClosePrice;
    private final BigDecimal lastPrice;
    private final BigDecimal lastQty;
    private final BigDecimal bidPrice;
    private final BigDecimal bidQty;
    private final BigDecimal askPrice;
    private final BigDecimal askQty;
    private final BigDecimal openPrice;
    private final BigDecimal highPrice;
    private final BigDecimal lowPrice;
    private final BigDecimal volume;
    private final BigDecimal quoteVolume;
    private final long openTime;
    private final long closeTime;
    private final long firstId;
    private final long lastId;
    private final long count;
    private final String symbol;
    private Instrument pair;
    private Ticker ticker;

    public BinanceTicker24h(@JsonProperty(value="priceChange") BigDecimal priceChange, @JsonProperty(value="priceChangePercent") BigDecimal priceChangePercent, @JsonProperty(value="weightedAvgPrice") BigDecimal weightedAvgPrice, @JsonProperty(value="prevClosePrice") BigDecimal prevClosePrice, @JsonProperty(value="lastPrice") BigDecimal lastPrice, @JsonProperty(value="lastQty") BigDecimal lastQty, @JsonProperty(value="bidPrice") BigDecimal bidPrice, @JsonProperty(value="bidQty") BigDecimal bidQty, @JsonProperty(value="askPrice") BigDecimal askPrice, @JsonProperty(value="askQty") BigDecimal askQty, @JsonProperty(value="openPrice") BigDecimal openPrice, @JsonProperty(value="highPrice") BigDecimal highPrice, @JsonProperty(value="lowPrice") BigDecimal lowPrice, @JsonProperty(value="volume") BigDecimal volume, @JsonProperty(value="quoteVolume") BigDecimal quoteVolume, @JsonProperty(value="openTime") long openTime, @JsonProperty(value="closeTime") long closeTime, @JsonProperty(value="firstId") long firstId, @JsonProperty(value="lastId") long lastId, @JsonProperty(value="count") long count, @JsonProperty(value="symbol") String symbol) {
        this.priceChange = priceChange;
        this.priceChangePercent = priceChangePercent;
        this.weightedAvgPrice = weightedAvgPrice;
        this.prevClosePrice = prevClosePrice;
        this.lastPrice = lastPrice;
        this.lastQty = lastQty;
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
        this.openPrice = openPrice;
        this.highPrice = highPrice;
        this.lowPrice = lowPrice;
        this.volume = volume;
        this.quoteVolume = quoteVolume;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.firstId = firstId;
        this.lastId = lastId;
        this.count = count;
        this.symbol = symbol;
    }

    public void setInstrument(Instrument pair) {
        this.pair = pair;
    }

    public synchronized Ticker toTicker(boolean isFuture) {
        Instrument instrument = this.pair;
        if (instrument == null) {
            instrument = BinanceAdapters.adaptSymbol(this.symbol, isFuture);
        }
        if (this.ticker == null) {
            this.ticker = new Ticker.Builder().instrument(instrument).open(this.openPrice).ask(this.askPrice).bid(this.bidPrice).last(this.lastPrice).high(this.highPrice).low(this.lowPrice).volume(this.volume).vwap(this.weightedAvgPrice).askSize(this.askQty).bidSize(this.bidQty).quoteVolume(this.quoteVolume).timestamp(this.closeTime > 0L ? new Date(this.closeTime) : null).percentageChange(this.priceChangePercent).build();
        }
        return this.ticker;
    }

    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public BigDecimal getPriceChangePercent() {
        return this.priceChangePercent;
    }

    public BigDecimal getWeightedAvgPrice() {
        return this.weightedAvgPrice;
    }

    public BigDecimal getPrevClosePrice() {
        return this.prevClosePrice;
    }

    public BigDecimal getLastPrice() {
        return this.lastPrice;
    }

    public BigDecimal getLastQty() {
        return this.lastQty;
    }

    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    public BigDecimal getAskQty() {
        return this.askQty;
    }

    public BigDecimal getOpenPrice() {
        return this.openPrice;
    }

    public BigDecimal getHighPrice() {
        return this.highPrice;
    }

    public BigDecimal getLowPrice() {
        return this.lowPrice;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getQuoteVolume() {
        return this.quoteVolume;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public long getCloseTime() {
        return this.closeTime;
    }

    public long getFirstId() {
        return this.firstId;
    }

    public long getLastId() {
        return this.lastId;
    }

    public long getCount() {
        return this.count;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Instrument getPair() {
        return this.pair;
    }

    public Ticker getTicker() {
        return this.ticker;
    }
}

