/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bibox.BiboxException;
import org.knowm.xchange.bibox.dto.BiboxAdapters;
import org.knowm.xchange.bibox.dto.BiboxCommand;
import org.knowm.xchange.bibox.dto.BiboxCommands;
import org.knowm.xchange.bibox.dto.BiboxMultipleResponses;
import org.knowm.xchange.bibox.dto.BiboxSingleResponse;
import org.knowm.xchange.bibox.dto.trade.BiboxAccountType;
import org.knowm.xchange.bibox.dto.trade.BiboxCancelTradeCommand;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderHistoryCommand;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderPendingListCommand;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderPendingListCommandBody;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderSide;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderType;
import org.knowm.xchange.bibox.dto.trade.BiboxOrders;
import org.knowm.xchange.bibox.dto.trade.BiboxTradeCommand;
import org.knowm.xchange.bibox.service.BiboxBaseService;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;

public class BiboxTradeServiceRaw
extends BiboxBaseService {
    public BiboxTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String placeBiboxLimitOrder(LimitOrder limitOrder) {
        try {
            BiboxTradeCommand cmd = new BiboxTradeCommand(BiboxAdapters.toBiboxPair((Instrument)limitOrder.getCurrencyPair()), BiboxAccountType.REGULAR.asInt(), BiboxOrderType.LIMIT_ORDER.asInt(), BiboxOrderSide.fromOrderType(limitOrder.getType()).asInt(), true, limitOrder.getLimitPrice(), limitOrder.getOriginalAmount(), null);
            BiboxSingleResponse<String> response = this.bibox.trade(BiboxCommands.of(new BiboxCommand[]{cmd}).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
            return response.get().getResult();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public String placeBiboxMarketOrder(MarketOrder marketOrder) {
        try {
            BiboxTradeCommand cmd = new BiboxTradeCommand(BiboxAdapters.toBiboxPair((Instrument)marketOrder.getCurrencyPair()), BiboxAccountType.REGULAR.asInt(), BiboxOrderType.MARKET_ORDER.asInt(), BiboxOrderSide.fromOrderType(marketOrder.getType()).asInt(), true, null, marketOrder.getOriginalAmount(), null);
            BiboxSingleResponse<String> response = this.bibox.trade(BiboxCommands.of(new BiboxCommand[]{cmd}).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
            return response.get().getResult();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public void cancelBiboxOrder(String orderId) {
        try {
            BiboxCancelTradeCommand cmd = new BiboxCancelTradeCommand(orderId);
            BiboxSingleResponse<String> response = this.bibox.cancelTrade(BiboxCommands.of(new BiboxCommand[]{cmd}).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public BiboxOrders getBiboxOpenOrders() {
        return this.getBiboxOpenOrders(null);
    }

    public BiboxOrders getBiboxOpenOrders(Integer page) {
        try {
            BiboxOrderPendingListCommandBody body = new BiboxOrderPendingListCommandBody(page == null ? 1 : page, Integer.MAX_VALUE);
            BiboxOrderPendingListCommand cmd = new BiboxOrderPendingListCommand(body);
            BiboxSingleResponse<BiboxOrders> response = this.bibox.orderPendingList(BiboxCommands.of(new BiboxCommand[]{cmd}).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
            return response.get().getResult();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public BiboxOrders getBiboxOrderHistory() {
        try {
            BiboxOrderPendingListCommandBody body = new BiboxOrderPendingListCommandBody(1, Integer.MAX_VALUE);
            BiboxOrderHistoryCommand cmd = new BiboxOrderHistoryCommand(body);
            BiboxSingleResponse<BiboxOrders> response = this.bibox.orderPendingList(BiboxCommands.of(new BiboxCommand[]{cmd}).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
            return response.get().getResult();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public void cancelBiboxOrders(List<String> orderIds) {
        try {
            List<BiboxCommand<?>> cmds = orderIds.stream().map(BiboxCancelTradeCommand::new).collect(Collectors.toList());
            BiboxMultipleResponses<String> response = this.bibox.cancelTrades(BiboxCommands.of(cmds).json(), this.apiKey, this.signatureCreator);
            BiboxTradeServiceRaw.throwErrors(response);
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }
}

