/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bibox.dto.BiboxAdapters;
import org.knowm.xchange.bibox.service.BiboxTradeServiceRaw;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BiboxTradeService
extends BiboxTradeServiceRaw
implements TradeService {
    public BiboxTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return BiboxAdapters.adaptOpenOrders(this.getBiboxOpenOrders());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        return this.getOpenOrders();
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeBiboxMarketOrder(marketOrder).toString();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeBiboxLimitOrder(limitOrder).toString();
    }

    public boolean cancelOrder(String orderId) throws IOException {
        this.cancelBiboxOrder(orderId);
        return true;
    }

    public boolean cancelOrders(List<String> orderIds) throws IOException {
        this.cancelBiboxOrders(orderIds);
        return true;
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        throw new ExchangeException("Need order ID for cancelling orders.");
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        return BiboxAdapters.adaptUserTrades(this.getBiboxOrderHistory());
    }

    public TradeHistoryParams createTradeHistoryParams() {
        throw new NotYetImplementedForExchangeException("This operation is not yet implemented for this exchange");
    }

    public OpenOrdersParams createOpenOrdersParams() {
        throw new NotYetImplementedForExchangeException("This operation is not yet implemented for this exchange");
    }

    public String placeStopOrder(StopOrder arg0) throws IOException {
        throw new NotYetImplementedForExchangeException("This operation is not yet implemented for this exchange");
    }
}

