/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bibox.dto.BiboxAdapters;
import org.knowm.xchange.bibox.dto.marketdata.BiboxMarket;
import org.knowm.xchange.bibox.dto.trade.BiboxDeals;
import org.knowm.xchange.bibox.dto.trade.BiboxOrderBook;
import org.knowm.xchange.bibox.service.BiboxMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BiboxMarketDataService
extends BiboxMarketDataServiceRaw
implements MarketDataService {
    public BiboxMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return BiboxAdapters.adaptTicker(this.getBiboxTicker(currencyPair), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        Integer depth = 16;
        if (args != null && args.length > 0 && args[0] instanceof Integer && (Integer)args[0] > 0) {
            depth = (Integer)args[0];
        }
        BiboxOrderBook biboxOrderBook = this.getBiboxOrderBook(currencyPair, depth);
        return BiboxAdapters.adaptOrderBook(biboxOrderBook, currencyPair);
    }

    public List<OrderBook> getAllOrderBooks(Integer depth) {
        return this.getOrderBooks(depth, this.exchange.getExchangeInstruments());
    }

    public List<OrderBook> getOrderBooks(Integer depth, Collection<Instrument> currencyPairs) {
        if (depth == null) {
            depth = 200;
        }
        List<BiboxOrderBook> biboxOrderBooks = this.getBiboxOrderBooks(depth, currencyPairs);
        return BiboxAdapters.adaptAllOrderBooks(biboxOrderBooks);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        Integer depth = 200;
        if (args != null && args.length > 0 && args[0] instanceof Integer && (Integer)args[0] > 0) {
            depth = (Integer)args[0];
        }
        List<BiboxDeals> biboxDeals = this.getBiboxDeals(currencyPair, depth);
        return BiboxAdapters.adaptDeals(biboxDeals, currencyPair);
    }

    public ExchangeMetaData getMetadata() throws IOException {
        List<BiboxMarket> markets = this.getAllBiboxMarkets();
        return BiboxAdapters.adaptMetadata(markets);
    }
}

