/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import jakarta.ws.rs.FormParam;
import java.io.UnsupportedEncodingException;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class BiboxDigest
extends BaseParamsDigest {
    private BiboxDigest(String secretKey) {
        super(secretKey, "HmacMD5");
    }

    public static BiboxDigest createInstance(String secretKey) {
        return secretKey == null ? null : new BiboxDigest(secretKey);
    }

    public String digestParams(RestInvocation restInvocation) {
        String cmds = (String)restInvocation.getParamValue(FormParam.class, "cmds");
        try {
            return DigestUtils.bytesToHex((byte[])this.getMac().doFinal(cmds.getBytes("UTF-8"))).toLowerCase();
        }
        catch (UnsupportedEncodingException | IllegalStateException e1) {
            throw new RuntimeException(e1.getMessage());
        }
    }
}

