/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bibox.BiboxException;
import org.knowm.xchange.bibox.dto.BiboxCommands;
import org.knowm.xchange.bibox.dto.BiboxPagedResponses;
import org.knowm.xchange.bibox.dto.BiboxSingleResponse;
import org.knowm.xchange.bibox.dto.account.BiboxAsset;
import org.knowm.xchange.bibox.dto.account.BiboxAssetsResult;
import org.knowm.xchange.bibox.dto.account.BiboxDeposit;
import org.knowm.xchange.bibox.dto.account.BiboxFundsCommandBody;
import org.knowm.xchange.bibox.dto.account.BiboxTransferCommandBody;
import org.knowm.xchange.bibox.dto.account.BiboxWithdrawal;
import org.knowm.xchange.bibox.service.BiboxBaseService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;

public class BiboxAccountServiceRaw
extends BiboxBaseService {
    protected BiboxAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<BiboxAsset> getBiboxAccountInfo() {
        try {
            BiboxSingleResponse<BiboxAssetsResult> response = this.bibox.assets(BiboxCommands.ASSETS_CMD.json(), this.apiKey, this.signatureCreator);
            BiboxAccountServiceRaw.throwErrors(response);
            return response.get().getResult().getAssets_list();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public String requestBiboxDepositAddress(Currency currency) {
        try {
            BiboxSingleResponse<String> response = this.bibox.depositAddress(BiboxCommands.depositAddressCommand(currency.getCurrencyCode()).json(), this.apiKey, this.signatureCreator);
            BiboxAccountServiceRaw.throwErrors(response);
            return response.get().getResult();
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public BiboxPagedResponses.BiboxPage<BiboxWithdrawal> requestBiboxWithdrawals(BiboxFundsCommandBody body) {
        try {
            BiboxPagedResponses<BiboxWithdrawal> response = this.bibox.transferOutList(BiboxCommands.withdrawalsCommand(body).json(), this.apiKey, this.signatureCreator);
            BiboxAccountServiceRaw.throwErrors(response);
            BiboxPagedResponses.BiboxPage page = (BiboxPagedResponses.BiboxPage)response.get().getResult();
            return page;
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public BiboxPagedResponses.BiboxPage<BiboxDeposit> requestBiboxDeposits(BiboxFundsCommandBody body) {
        try {
            BiboxPagedResponses<BiboxDeposit> response = this.bibox.transferInList(BiboxCommands.depositsCommand(body).json(), this.apiKey, this.signatureCreator);
            BiboxAccountServiceRaw.throwErrors(response);
            BiboxPagedResponses.BiboxPage page = (BiboxPagedResponses.BiboxPage)response.get().getResult();
            return page;
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }

    public void requestBiboxWithdraw(BiboxTransferCommandBody body) {
        try {
            BiboxSingleResponse<String> response = this.bibox.transfer(BiboxCommands.transferCommand(body).json(), this.apiKey, this.signatureCreator);
            BiboxAccountServiceRaw.throwErrors(response);
        }
        catch (BiboxException e) {
            throw new ExchangeException(e.getMessage());
        }
    }
}

