/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bibox.dto.BiboxAdapters;
import org.knowm.xchange.bibox.dto.account.BiboxFundsCommandBody;
import org.knowm.xchange.bibox.service.BiboxAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BiboxAccountService
extends BiboxAccountServiceRaw
implements AccountService {
    public BiboxAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return BiboxAdapters.adaptAccountInfo(this.getBiboxAccountInfo());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        throw new NotYetImplementedForExchangeException("This operation is not yet implemented for this exchange");
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        throw new NotYetImplementedForExchangeException("This operation is not yet implemented for this exchange");
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.requestBiboxDepositAddress(currency);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BiboxFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) {
        if (!(params instanceof TradeHistoryParamCurrency)) {
            throw new RuntimeException("You must provide the currency for funding history @ Bibox.");
        }
        Currency c = ((TradeHistoryParamCurrency)params).getCurrency();
        if (c == null) {
            throw new RuntimeException("You must provide the currency for funding history @ Bibox.");
        }
        boolean deposits = false;
        boolean withdrawals = false;
        if (params instanceof HistoryParamsFundingType) {
            HistoryParamsFundingType typeParams = (HistoryParamsFundingType)params;
            FundingRecord.Type type = typeParams.getType();
            deposits = type == null || type == FundingRecord.Type.DEPOSIT;
            withdrawals = type == null || type == FundingRecord.Type.WITHDRAWAL;
        }
        BiboxFundsCommandBody body = new BiboxFundsCommandBody(c.getCurrencyCode());
        ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
        if (deposits) {
            this.requestBiboxDeposits(body).getItems().forEach(d -> result.add(BiboxAdapters.adaptDeposit(d)));
        }
        if (withdrawals) {
            this.requestBiboxWithdrawals(body).getItems().forEach(d -> result.add(BiboxAdapters.adaptDeposit(d)));
        }
        return result;
    }

    public static class BiboxFundingHistoryParams
    implements TradeHistoryParamCurrency,
    HistoryParamsFundingType {
        private FundingRecord.Type type;
        private Currency currency;

        public FundingRecord.Type getType() {
            return this.type;
        }

        public void setType(FundingRecord.Type type) {
            this.type = type;
        }

        public Currency getCurrency() {
            return this.currency;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }
    }
}

