/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.knowm.xchange.dto.Order;

public enum BiboxOrderStatus {
    PENDING(1, Order.OrderStatus.NEW),
    PART_COMPLETED(2, Order.OrderStatus.PARTIALLY_FILLED),
    COMPLETED(3, Order.OrderStatus.FILLED),
    PART_CANCELED(4, Order.OrderStatus.PARTIALLY_CANCELED),
    CANCELLED(5, Order.OrderStatus.CANCELED),
    CANCELLING(6, Order.OrderStatus.PENDING_CANCEL);

    private int orderStatus;
    private Order.OrderStatus xchangeStatus;

    private BiboxOrderStatus(int orderStatus, Order.OrderStatus xchangeStatus) {
        this.orderStatus = orderStatus;
        this.xchangeStatus = xchangeStatus;
    }

    @JsonCreator
    public static BiboxOrderStatus fromInt(int orderStatus) {
        switch (orderStatus) {
            case 1: {
                return PENDING;
            }
            case 2: {
                return PART_COMPLETED;
            }
            case 3: {
                return COMPLETED;
            }
            case 4: {
                return PART_CANCELED;
            }
            case 5: {
                return CANCELLED;
            }
            case 6: {
                return CANCELLING;
            }
        }
        throw new RuntimeException("Unexpected Bibox order status!");
    }

    public int asInt() {
        return this.orderStatus;
    }

    public Order.OrderStatus getOrderStatus() {
        return this.xchangeStatus;
    }
}

