/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bibox.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.exceptions.ExchangeException;

public enum BiboxOrderSide {
    BID(1, Order.OrderType.BID),
    ASK(2, Order.OrderType.ASK);

    private int orderSide;
    private Order.OrderType orderType;

    private BiboxOrderSide(int orderSide, Order.OrderType orderType) {
        this.orderSide = orderSide;
        this.orderType = orderType;
    }

    public static BiboxOrderSide fromOrderType(Order.OrderType orderType) {
        switch (orderType) {
            case BID: {
                return BID;
            }
            case ASK: {
                return ASK;
            }
        }
        throw new ExchangeException("Order type " + orderType + " unsupported.");
    }

    @JsonCreator
    public static BiboxOrderSide fromInt(int orderSide) {
        switch (orderSide) {
            case 1: {
                return BID;
            }
            case 2: {
                return ASK;
            }
        }
        throw new ExchangeException("Unexpected Bibox order side.");
    }

    public int asInt() {
        return this.orderSide;
    }

    public Order.OrderType getOrderType() {
        return this.orderType;
    }
}

