/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcOutputDetail;
import net.osslabz.lnd.dto.LnrpcPreviousOutPoint;

public class LnrpcTransaction {
    public static final String SERIALIZED_NAME_TX_HASH = "tx_hash";
    @SerializedName(value="tx_hash")
    private String txHash;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_NUM_CONFIRMATIONS = "num_confirmations";
    @SerializedName(value="num_confirmations")
    private Integer numConfirmations;
    public static final String SERIALIZED_NAME_BLOCK_HASH = "block_hash";
    @SerializedName(value="block_hash")
    private String blockHash;
    public static final String SERIALIZED_NAME_BLOCK_HEIGHT = "block_height";
    @SerializedName(value="block_height")
    private Integer blockHeight;
    public static final String SERIALIZED_NAME_TIME_STAMP = "time_stamp";
    @SerializedName(value="time_stamp")
    private String timeStamp;
    public static final String SERIALIZED_NAME_TOTAL_FEES = "total_fees";
    @SerializedName(value="total_fees")
    private String totalFees;
    public static final String SERIALIZED_NAME_DEST_ADDRESSES = "dest_addresses";
    @SerializedName(value="dest_addresses")
    private List<String> destAddresses = null;
    public static final String SERIALIZED_NAME_OUTPUT_DETAILS = "output_details";
    @SerializedName(value="output_details")
    private List<LnrpcOutputDetail> outputDetails = null;
    public static final String SERIALIZED_NAME_RAW_TX_HEX = "raw_tx_hex";
    @SerializedName(value="raw_tx_hex")
    private String rawTxHex;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_PREVIOUS_OUTPOINTS = "previous_outpoints";
    @SerializedName(value="previous_outpoints")
    private List<LnrpcPreviousOutPoint> previousOutpoints = null;

    public LnrpcTransaction txHash(String txHash) {
        this.txHash = txHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public LnrpcTransaction amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public LnrpcTransaction numConfirmations(Integer numConfirmations) {
        this.numConfirmations = numConfirmations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getNumConfirmations() {
        return this.numConfirmations;
    }

    public void setNumConfirmations(Integer numConfirmations) {
        this.numConfirmations = numConfirmations;
    }

    public LnrpcTransaction blockHash(String blockHash) {
        this.blockHash = blockHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public LnrpcTransaction blockHeight(Integer blockHeight) {
        this.blockHeight = blockHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(Integer blockHeight) {
        this.blockHeight = blockHeight;
    }

    public LnrpcTransaction timeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public LnrpcTransaction totalFees(String totalFees) {
        this.totalFees = totalFees;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getTotalFees() {
        return this.totalFees;
    }

    public void setTotalFees(String totalFees) {
        this.totalFees = totalFees;
    }

    public LnrpcTransaction destAddresses(List<String> destAddresses) {
        this.destAddresses = destAddresses;
        return this;
    }

    public LnrpcTransaction addDestAddressesItem(String destAddressesItem) {
        if (this.destAddresses == null) {
            this.destAddresses = new ArrayList<String>();
        }
        this.destAddresses.add(destAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Addresses that received funds for this transaction. Deprecated as it is now incorporated in the output_details field.")
    public List<String> getDestAddresses() {
        return this.destAddresses;
    }

    public void setDestAddresses(List<String> destAddresses) {
        this.destAddresses = destAddresses;
    }

    public LnrpcTransaction outputDetails(List<LnrpcOutputDetail> outputDetails) {
        this.outputDetails = outputDetails;
        return this;
    }

    public LnrpcTransaction addOutputDetailsItem(LnrpcOutputDetail outputDetailsItem) {
        if (this.outputDetails == null) {
            this.outputDetails = new ArrayList<LnrpcOutputDetail>();
        }
        this.outputDetails.add(outputDetailsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcOutputDetail> getOutputDetails() {
        return this.outputDetails;
    }

    public void setOutputDetails(List<LnrpcOutputDetail> outputDetails) {
        this.outputDetails = outputDetails;
    }

    public LnrpcTransaction rawTxHex(String rawTxHex) {
        this.rawTxHex = rawTxHex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The raw transaction hex.")
    public String getRawTxHex() {
        return this.rawTxHex;
    }

    public void setRawTxHex(String rawTxHex) {
        this.rawTxHex = rawTxHex;
    }

    public LnrpcTransaction label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A label that was optionally set on transaction broadcast.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LnrpcTransaction previousOutpoints(List<LnrpcPreviousOutPoint> previousOutpoints) {
        this.previousOutpoints = previousOutpoints;
        return this;
    }

    public LnrpcTransaction addPreviousOutpointsItem(LnrpcPreviousOutPoint previousOutpointsItem) {
        if (this.previousOutpoints == null) {
            this.previousOutpoints = new ArrayList<LnrpcPreviousOutPoint>();
        }
        this.previousOutpoints.add(previousOutpointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PreviousOutpoints/Inputs of this transaction.")
    public List<LnrpcPreviousOutPoint> getPreviousOutpoints() {
        return this.previousOutpoints;
    }

    public void setPreviousOutpoints(List<LnrpcPreviousOutPoint> previousOutpoints) {
        this.previousOutpoints = previousOutpoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcTransaction lnrpcTransaction = (LnrpcTransaction)o;
        return Objects.equals(this.txHash, lnrpcTransaction.txHash) && Objects.equals(this.amount, lnrpcTransaction.amount) && Objects.equals(this.numConfirmations, lnrpcTransaction.numConfirmations) && Objects.equals(this.blockHash, lnrpcTransaction.blockHash) && Objects.equals(this.blockHeight, lnrpcTransaction.blockHeight) && Objects.equals(this.timeStamp, lnrpcTransaction.timeStamp) && Objects.equals(this.totalFees, lnrpcTransaction.totalFees) && Objects.equals(this.destAddresses, lnrpcTransaction.destAddresses) && Objects.equals(this.outputDetails, lnrpcTransaction.outputDetails) && Objects.equals(this.rawTxHex, lnrpcTransaction.rawTxHex) && Objects.equals(this.label, lnrpcTransaction.label) && Objects.equals(this.previousOutpoints, lnrpcTransaction.previousOutpoints);
    }

    public int hashCode() {
        return Objects.hash(this.txHash, this.amount, this.numConfirmations, this.blockHash, this.blockHeight, this.timeStamp, this.totalFees, this.destAddresses, this.outputDetails, this.rawTxHex, this.label, this.previousOutpoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcTransaction {\n");
        sb.append("    txHash: ").append(this.toIndentedString(this.txHash)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    numConfirmations: ").append(this.toIndentedString(this.numConfirmations)).append("\n");
        sb.append("    blockHash: ").append(this.toIndentedString(this.blockHash)).append("\n");
        sb.append("    blockHeight: ").append(this.toIndentedString(this.blockHeight)).append("\n");
        sb.append("    timeStamp: ").append(this.toIndentedString(this.timeStamp)).append("\n");
        sb.append("    totalFees: ").append(this.toIndentedString(this.totalFees)).append("\n");
        sb.append("    destAddresses: ").append(this.toIndentedString(this.destAddresses)).append("\n");
        sb.append("    outputDetails: ").append(this.toIndentedString(this.outputDetails)).append("\n");
        sb.append("    rawTxHex: ").append(this.toIndentedString(this.rawTxHex)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    previousOutpoints: ").append(this.toIndentedString(this.previousOutpoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

