/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcRoute;

public class LnrpcSendToRouteRequest {
    public static final String SERIALIZED_NAME_PAYMENT_HASH = "payment_hash";
    @SerializedName(value="payment_hash")
    private byte[] paymentHash;
    public static final String SERIALIZED_NAME_PAYMENT_HASH_STRING = "payment_hash_string";
    @SerializedName(value="payment_hash_string")
    private String paymentHashString;
    public static final String SERIALIZED_NAME_ROUTE = "route";
    @SerializedName(value="route")
    private LnrpcRoute route;

    public LnrpcSendToRouteRequest paymentHash(byte[] paymentHash) {
        this.paymentHash = paymentHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment hash to use for the HTLC. When using REST, this field must be encoded as base64.")
    public byte[] getPaymentHash() {
        return this.paymentHash;
    }

    public void setPaymentHash(byte[] paymentHash) {
        this.paymentHash = paymentHash;
    }

    public LnrpcSendToRouteRequest paymentHashString(String paymentHashString) {
        this.paymentHashString = paymentHashString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional hex-encoded payment hash to be used for the HTLC. Deprecated now that the REST gateway supports base64 encoding of bytes fields.")
    public String getPaymentHashString() {
        return this.paymentHashString;
    }

    public void setPaymentHashString(String paymentHashString) {
        this.paymentHashString = paymentHashString;
    }

    public LnrpcSendToRouteRequest route(LnrpcRoute route) {
        this.route = route;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRoute getRoute() {
        return this.route;
    }

    public void setRoute(LnrpcRoute route) {
        this.route = route;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcSendToRouteRequest lnrpcSendToRouteRequest = (LnrpcSendToRouteRequest)o;
        return Arrays.equals(this.paymentHash, lnrpcSendToRouteRequest.paymentHash) && Objects.equals(this.paymentHashString, lnrpcSendToRouteRequest.paymentHashString) && Objects.equals(this.route, lnrpcSendToRouteRequest.route);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.paymentHash), this.paymentHashString, this.route);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcSendToRouteRequest {\n");
        sb.append("    paymentHash: ").append(this.toIndentedString(this.paymentHash)).append("\n");
        sb.append("    paymentHashString: ").append(this.toIndentedString(this.paymentHashString)).append("\n");
        sb.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

