/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcFeatureBit;
import net.osslabz.lnd.dto.LnrpcFeeLimit;

public class LnrpcSendRequest {
    public static final String SERIALIZED_NAME_DEST = "dest";
    @SerializedName(value="dest")
    private byte[] dest;
    public static final String SERIALIZED_NAME_DEST_STRING = "dest_string";
    @SerializedName(value="dest_string")
    private String destString;
    public static final String SERIALIZED_NAME_AMT = "amt";
    @SerializedName(value="amt")
    private String amt;
    public static final String SERIALIZED_NAME_AMT_MSAT = "amt_msat";
    @SerializedName(value="amt_msat")
    private String amtMsat;
    public static final String SERIALIZED_NAME_PAYMENT_HASH = "payment_hash";
    @SerializedName(value="payment_hash")
    private byte[] paymentHash;
    public static final String SERIALIZED_NAME_PAYMENT_HASH_STRING = "payment_hash_string";
    @SerializedName(value="payment_hash_string")
    private String paymentHashString;
    public static final String SERIALIZED_NAME_PAYMENT_REQUEST = "payment_request";
    @SerializedName(value="payment_request")
    private String paymentRequest;
    public static final String SERIALIZED_NAME_FINAL_CLTV_DELTA = "final_cltv_delta";
    @SerializedName(value="final_cltv_delta")
    private Integer finalCltvDelta;
    public static final String SERIALIZED_NAME_FEE_LIMIT = "fee_limit";
    @SerializedName(value="fee_limit")
    private LnrpcFeeLimit feeLimit;
    public static final String SERIALIZED_NAME_OUTGOING_CHAN_ID = "outgoing_chan_id";
    @SerializedName(value="outgoing_chan_id")
    private String outgoingChanId;
    public static final String SERIALIZED_NAME_LAST_HOP_PUBKEY = "last_hop_pubkey";
    @SerializedName(value="last_hop_pubkey")
    private byte[] lastHopPubkey;
    public static final String SERIALIZED_NAME_CLTV_LIMIT = "cltv_limit";
    @SerializedName(value="cltv_limit")
    private Long cltvLimit;
    public static final String SERIALIZED_NAME_DEST_CUSTOM_RECORDS = "dest_custom_records";
    @SerializedName(value="dest_custom_records")
    private Map<String, byte[]> destCustomRecords = null;
    public static final String SERIALIZED_NAME_ALLOW_SELF_PAYMENT = "allow_self_payment";
    @SerializedName(value="allow_self_payment")
    private Boolean allowSelfPayment;
    public static final String SERIALIZED_NAME_DEST_FEATURES = "dest_features";
    @SerializedName(value="dest_features")
    private List<LnrpcFeatureBit> destFeatures = null;
    public static final String SERIALIZED_NAME_PAYMENT_ADDR = "payment_addr";
    @SerializedName(value="payment_addr")
    private byte[] paymentAddr;

    public LnrpcSendRequest dest(byte[] dest) {
        this.dest = dest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identity pubkey of the payment recipient. When using REST, this field must be encoded as base64.")
    public byte[] getDest() {
        return this.dest;
    }

    public void setDest(byte[] dest) {
        this.dest = dest;
    }

    public LnrpcSendRequest destString(String destString) {
        this.destString = destString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hex-encoded identity pubkey of the payment recipient. Deprecated now that the REST gateway supports base64 encoding of bytes fields.")
    public String getDestString() {
        return this.destString;
    }

    public void setDestString(String destString) {
        this.destString = destString;
    }

    public LnrpcSendRequest amt(String amt) {
        this.amt = amt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to send expressed in satoshis.  The fields amt and amt_msat are mutually exclusive.")
    public String getAmt() {
        return this.amt;
    }

    public void setAmt(String amt) {
        this.amt = amt;
    }

    public LnrpcSendRequest amtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to send expressed in millisatoshis.  The fields amt and amt_msat are mutually exclusive.")
    public String getAmtMsat() {
        return this.amtMsat;
    }

    public void setAmtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
    }

    public LnrpcSendRequest paymentHash(byte[] paymentHash) {
        this.paymentHash = paymentHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash to use within the payment's HTLC. When using REST, this field must be encoded as base64.")
    public byte[] getPaymentHash() {
        return this.paymentHash;
    }

    public void setPaymentHash(byte[] paymentHash) {
        this.paymentHash = paymentHash;
    }

    public LnrpcSendRequest paymentHashString(String paymentHashString) {
        this.paymentHashString = paymentHashString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hex-encoded hash to use within the payment's HTLC. Deprecated now that the REST gateway supports base64 encoding of bytes fields.")
    public String getPaymentHashString() {
        return this.paymentHashString;
    }

    public void setPaymentHashString(String paymentHashString) {
        this.paymentHashString = paymentHashString;
    }

    public LnrpcSendRequest paymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A bare-bones invoice for a payment within the Lightning Network. With the details of the invoice, the sender has all the data necessary to send a payment to the recipient.")
    public String getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public LnrpcSendRequest finalCltvDelta(Integer finalCltvDelta) {
        this.finalCltvDelta = finalCltvDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CLTV delta from the current height that should be used to set the timelock for the final hop.")
    public Integer getFinalCltvDelta() {
        return this.finalCltvDelta;
    }

    public void setFinalCltvDelta(Integer finalCltvDelta) {
        this.finalCltvDelta = finalCltvDelta;
    }

    public LnrpcSendRequest feeLimit(LnrpcFeeLimit feeLimit) {
        this.feeLimit = feeLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcFeeLimit getFeeLimit() {
        return this.feeLimit;
    }

    public void setFeeLimit(LnrpcFeeLimit feeLimit) {
        this.feeLimit = feeLimit;
    }

    public LnrpcSendRequest outgoingChanId(String outgoingChanId) {
        this.outgoingChanId = outgoingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The channel id of the channel that must be taken to the first hop. If zero, any channel may be used.")
    public String getOutgoingChanId() {
        return this.outgoingChanId;
    }

    public void setOutgoingChanId(String outgoingChanId) {
        this.outgoingChanId = outgoingChanId;
    }

    public LnrpcSendRequest lastHopPubkey(byte[] lastHopPubkey) {
        this.lastHopPubkey = lastHopPubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pubkey of the last hop of the route. If empty, any hop may be used.")
    public byte[] getLastHopPubkey() {
        return this.lastHopPubkey;
    }

    public void setLastHopPubkey(byte[] lastHopPubkey) {
        this.lastHopPubkey = lastHopPubkey;
    }

    public LnrpcSendRequest cltvLimit(Long cltvLimit) {
        this.cltvLimit = cltvLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional maximum total time lock for the route. This should not exceed lnd's `--max-cltv-expiry` setting. If zero, then the value of `--max-cltv-expiry` is enforced.")
    public Long getCltvLimit() {
        return this.cltvLimit;
    }

    public void setCltvLimit(Long cltvLimit) {
        this.cltvLimit = cltvLimit;
    }

    public LnrpcSendRequest destCustomRecords(Map<String, byte[]> destCustomRecords) {
        this.destCustomRecords = destCustomRecords;
        return this;
    }

    public LnrpcSendRequest putDestCustomRecordsItem(String key, byte[] destCustomRecordsItem) {
        if (this.destCustomRecords == null) {
            this.destCustomRecords = new HashMap<String, byte[]>();
        }
        this.destCustomRecords.put(key, destCustomRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional field that can be used to pass an arbitrary set of TLV records to a peer which understands the new records. This can be used to pass application specific data during the payment attempt. Record types are required to be in the custom range >= 65536. When using REST, the values must be encoded as base64.")
    public Map<String, byte[]> getDestCustomRecords() {
        return this.destCustomRecords;
    }

    public void setDestCustomRecords(Map<String, byte[]> destCustomRecords) {
        this.destCustomRecords = destCustomRecords;
    }

    public LnrpcSendRequest allowSelfPayment(Boolean allowSelfPayment) {
        this.allowSelfPayment = allowSelfPayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, circular payments to self are permitted.")
    public Boolean getAllowSelfPayment() {
        return this.allowSelfPayment;
    }

    public void setAllowSelfPayment(Boolean allowSelfPayment) {
        this.allowSelfPayment = allowSelfPayment;
    }

    public LnrpcSendRequest destFeatures(List<LnrpcFeatureBit> destFeatures) {
        this.destFeatures = destFeatures;
        return this;
    }

    public LnrpcSendRequest addDestFeaturesItem(LnrpcFeatureBit destFeaturesItem) {
        if (this.destFeatures == null) {
            this.destFeatures = new ArrayList<LnrpcFeatureBit>();
        }
        this.destFeatures.add(destFeaturesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Features assumed to be supported by the final node. All transitive feature dependencies must also be set properly. For a given feature bit pair, either optional or remote may be set, but not both. If this field is nil or empty, the router will try to load destination features from the graph as a fallback.")
    public List<LnrpcFeatureBit> getDestFeatures() {
        return this.destFeatures;
    }

    public void setDestFeatures(List<LnrpcFeatureBit> destFeatures) {
        this.destFeatures = destFeatures;
    }

    public LnrpcSendRequest paymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment address of the generated invoice.")
    public byte[] getPaymentAddr() {
        return this.paymentAddr;
    }

    public void setPaymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcSendRequest lnrpcSendRequest = (LnrpcSendRequest)o;
        return Arrays.equals(this.dest, lnrpcSendRequest.dest) && Objects.equals(this.destString, lnrpcSendRequest.destString) && Objects.equals(this.amt, lnrpcSendRequest.amt) && Objects.equals(this.amtMsat, lnrpcSendRequest.amtMsat) && Arrays.equals(this.paymentHash, lnrpcSendRequest.paymentHash) && Objects.equals(this.paymentHashString, lnrpcSendRequest.paymentHashString) && Objects.equals(this.paymentRequest, lnrpcSendRequest.paymentRequest) && Objects.equals(this.finalCltvDelta, lnrpcSendRequest.finalCltvDelta) && Objects.equals(this.feeLimit, lnrpcSendRequest.feeLimit) && Objects.equals(this.outgoingChanId, lnrpcSendRequest.outgoingChanId) && Arrays.equals(this.lastHopPubkey, lnrpcSendRequest.lastHopPubkey) && Objects.equals(this.cltvLimit, lnrpcSendRequest.cltvLimit) && Objects.equals(this.destCustomRecords, lnrpcSendRequest.destCustomRecords) && Objects.equals(this.allowSelfPayment, lnrpcSendRequest.allowSelfPayment) && Objects.equals(this.destFeatures, lnrpcSendRequest.destFeatures) && Arrays.equals(this.paymentAddr, lnrpcSendRequest.paymentAddr);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.dest), this.destString, this.amt, this.amtMsat, Arrays.hashCode(this.paymentHash), this.paymentHashString, this.paymentRequest, this.finalCltvDelta, this.feeLimit, this.outgoingChanId, Arrays.hashCode(this.lastHopPubkey), this.cltvLimit, this.destCustomRecords, this.allowSelfPayment, this.destFeatures, Arrays.hashCode(this.paymentAddr));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcSendRequest {\n");
        sb.append("    dest: ").append(this.toIndentedString(this.dest)).append("\n");
        sb.append("    destString: ").append(this.toIndentedString(this.destString)).append("\n");
        sb.append("    amt: ").append(this.toIndentedString(this.amt)).append("\n");
        sb.append("    amtMsat: ").append(this.toIndentedString(this.amtMsat)).append("\n");
        sb.append("    paymentHash: ").append(this.toIndentedString(this.paymentHash)).append("\n");
        sb.append("    paymentHashString: ").append(this.toIndentedString(this.paymentHashString)).append("\n");
        sb.append("    paymentRequest: ").append(this.toIndentedString(this.paymentRequest)).append("\n");
        sb.append("    finalCltvDelta: ").append(this.toIndentedString(this.finalCltvDelta)).append("\n");
        sb.append("    feeLimit: ").append(this.toIndentedString(this.feeLimit)).append("\n");
        sb.append("    outgoingChanId: ").append(this.toIndentedString(this.outgoingChanId)).append("\n");
        sb.append("    lastHopPubkey: ").append(this.toIndentedString(this.lastHopPubkey)).append("\n");
        sb.append("    cltvLimit: ").append(this.toIndentedString(this.cltvLimit)).append("\n");
        sb.append("    destCustomRecords: ").append(this.toIndentedString(this.destCustomRecords)).append("\n");
        sb.append("    allowSelfPayment: ").append(this.toIndentedString(this.allowSelfPayment)).append("\n");
        sb.append("    destFeatures: ").append(this.toIndentedString(this.destFeatures)).append("\n");
        sb.append("    paymentAddr: ").append(this.toIndentedString(this.paymentAddr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

