/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LnrpcSendManyRequest {
    public static final String SERIALIZED_NAME_ADDR_TO_AMOUNT = "AddrToAmount";
    @SerializedName(value="AddrToAmount")
    private Map<String, String> addrToAmount = null;
    public static final String SERIALIZED_NAME_TARGET_CONF = "target_conf";
    @SerializedName(value="target_conf")
    private Integer targetConf;
    public static final String SERIALIZED_NAME_SAT_PER_VBYTE = "sat_per_vbyte";
    @SerializedName(value="sat_per_vbyte")
    private String satPerVbyte;
    public static final String SERIALIZED_NAME_SAT_PER_BYTE = "sat_per_byte";
    @SerializedName(value="sat_per_byte")
    private String satPerByte;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_MIN_CONFS = "min_confs";
    @SerializedName(value="min_confs")
    private Integer minConfs;
    public static final String SERIALIZED_NAME_SPEND_UNCONFIRMED = "spend_unconfirmed";
    @SerializedName(value="spend_unconfirmed")
    private Boolean spendUnconfirmed;

    public LnrpcSendManyRequest addrToAmount(Map<String, String> addrToAmount) {
        this.addrToAmount = addrToAmount;
        return this;
    }

    public LnrpcSendManyRequest putAddrToAmountItem(String key, String addrToAmountItem) {
        if (this.addrToAmount == null) {
            this.addrToAmount = new HashMap<String, String>();
        }
        this.addrToAmount.put(key, addrToAmountItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getAddrToAmount() {
        return this.addrToAmount;
    }

    public void setAddrToAmount(Map<String, String> addrToAmount) {
        this.addrToAmount = addrToAmount;
    }

    public LnrpcSendManyRequest targetConf(Integer targetConf) {
        this.targetConf = targetConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target number of blocks that this transaction should be confirmed by.")
    public Integer getTargetConf() {
        return this.targetConf;
    }

    public void setTargetConf(Integer targetConf) {
        this.targetConf = targetConf;
    }

    public LnrpcSendManyRequest satPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A manual fee rate set in sat/vbyte that should be used when crafting the transaction.")
    public String getSatPerVbyte() {
        return this.satPerVbyte;
    }

    public void setSatPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
    }

    public LnrpcSendManyRequest satPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use sat_per_vbyte. A manual fee rate set in sat/vbyte that should be used when crafting the transaction.")
    public String getSatPerByte() {
        return this.satPerByte;
    }

    public void setSatPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
    }

    public LnrpcSendManyRequest label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional label for the transaction, limited to 500 characters.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LnrpcSendManyRequest minConfs(Integer minConfs) {
        this.minConfs = minConfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of confirmations each one of your outputs used for the transaction must satisfy.")
    public Integer getMinConfs() {
        return this.minConfs;
    }

    public void setMinConfs(Integer minConfs) {
        this.minConfs = minConfs;
    }

    public LnrpcSendManyRequest spendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether unconfirmed outputs should be used as inputs for the transaction.")
    public Boolean getSpendUnconfirmed() {
        return this.spendUnconfirmed;
    }

    public void setSpendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcSendManyRequest lnrpcSendManyRequest = (LnrpcSendManyRequest)o;
        return Objects.equals(this.addrToAmount, lnrpcSendManyRequest.addrToAmount) && Objects.equals(this.targetConf, lnrpcSendManyRequest.targetConf) && Objects.equals(this.satPerVbyte, lnrpcSendManyRequest.satPerVbyte) && Objects.equals(this.satPerByte, lnrpcSendManyRequest.satPerByte) && Objects.equals(this.label, lnrpcSendManyRequest.label) && Objects.equals(this.minConfs, lnrpcSendManyRequest.minConfs) && Objects.equals(this.spendUnconfirmed, lnrpcSendManyRequest.spendUnconfirmed);
    }

    public int hashCode() {
        return Objects.hash(this.addrToAmount, this.targetConf, this.satPerVbyte, this.satPerByte, this.label, this.minConfs, this.spendUnconfirmed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcSendManyRequest {\n");
        sb.append("    addrToAmount: ").append(this.toIndentedString(this.addrToAmount)).append("\n");
        sb.append("    targetConf: ").append(this.toIndentedString(this.targetConf)).append("\n");
        sb.append("    satPerVbyte: ").append(this.toIndentedString(this.satPerVbyte)).append("\n");
        sb.append("    satPerByte: ").append(this.toIndentedString(this.satPerByte)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    minConfs: ").append(this.toIndentedString(this.minConfs)).append("\n");
        sb.append("    spendUnconfirmed: ").append(this.toIndentedString(this.spendUnconfirmed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

