/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcSendCoinsRequest {
    public static final String SERIALIZED_NAME_ADDR = "addr";
    @SerializedName(value="addr")
    private String addr;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_TARGET_CONF = "target_conf";
    @SerializedName(value="target_conf")
    private Integer targetConf;
    public static final String SERIALIZED_NAME_SAT_PER_VBYTE = "sat_per_vbyte";
    @SerializedName(value="sat_per_vbyte")
    private String satPerVbyte;
    public static final String SERIALIZED_NAME_SAT_PER_BYTE = "sat_per_byte";
    @SerializedName(value="sat_per_byte")
    private String satPerByte;
    public static final String SERIALIZED_NAME_SEND_ALL = "send_all";
    @SerializedName(value="send_all")
    private Boolean sendAll;
    public static final String SERIALIZED_NAME_LABEL = "label";
    @SerializedName(value="label")
    private String label;
    public static final String SERIALIZED_NAME_MIN_CONFS = "min_confs";
    @SerializedName(value="min_confs")
    private Integer minConfs;
    public static final String SERIALIZED_NAME_SPEND_UNCONFIRMED = "spend_unconfirmed";
    @SerializedName(value="spend_unconfirmed")
    private Boolean spendUnconfirmed;

    public LnrpcSendCoinsRequest addr(String addr) {
        this.addr = addr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAddr() {
        return this.addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public LnrpcSendCoinsRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public LnrpcSendCoinsRequest targetConf(Integer targetConf) {
        this.targetConf = targetConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target number of blocks that this transaction should be confirmed by.")
    public Integer getTargetConf() {
        return this.targetConf;
    }

    public void setTargetConf(Integer targetConf) {
        this.targetConf = targetConf;
    }

    public LnrpcSendCoinsRequest satPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A manual fee rate set in sat/vbyte that should be used when crafting the transaction.")
    public String getSatPerVbyte() {
        return this.satPerVbyte;
    }

    public void setSatPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
    }

    public LnrpcSendCoinsRequest satPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use sat_per_vbyte. A manual fee rate set in sat/vbyte that should be used when crafting the transaction.")
    public String getSatPerByte() {
        return this.satPerByte;
    }

    public void setSatPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
    }

    public LnrpcSendCoinsRequest sendAll(Boolean sendAll) {
        this.sendAll = sendAll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, then the amount field will be ignored, and lnd will attempt to send all the coins under control of the internal wallet to the specified address.")
    public Boolean getSendAll() {
        return this.sendAll;
    }

    public void setSendAll(Boolean sendAll) {
        this.sendAll = sendAll;
    }

    public LnrpcSendCoinsRequest label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional label for the transaction, limited to 500 characters.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LnrpcSendCoinsRequest minConfs(Integer minConfs) {
        this.minConfs = minConfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of confirmations each one of your outputs used for the transaction must satisfy.")
    public Integer getMinConfs() {
        return this.minConfs;
    }

    public void setMinConfs(Integer minConfs) {
        this.minConfs = minConfs;
    }

    public LnrpcSendCoinsRequest spendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether unconfirmed outputs should be used as inputs for the transaction.")
    public Boolean getSpendUnconfirmed() {
        return this.spendUnconfirmed;
    }

    public void setSpendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcSendCoinsRequest lnrpcSendCoinsRequest = (LnrpcSendCoinsRequest)o;
        return Objects.equals(this.addr, lnrpcSendCoinsRequest.addr) && Objects.equals(this.amount, lnrpcSendCoinsRequest.amount) && Objects.equals(this.targetConf, lnrpcSendCoinsRequest.targetConf) && Objects.equals(this.satPerVbyte, lnrpcSendCoinsRequest.satPerVbyte) && Objects.equals(this.satPerByte, lnrpcSendCoinsRequest.satPerByte) && Objects.equals(this.sendAll, lnrpcSendCoinsRequest.sendAll) && Objects.equals(this.label, lnrpcSendCoinsRequest.label) && Objects.equals(this.minConfs, lnrpcSendCoinsRequest.minConfs) && Objects.equals(this.spendUnconfirmed, lnrpcSendCoinsRequest.spendUnconfirmed);
    }

    public int hashCode() {
        return Objects.hash(this.addr, this.amount, this.targetConf, this.satPerVbyte, this.satPerByte, this.sendAll, this.label, this.minConfs, this.spendUnconfirmed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcSendCoinsRequest {\n");
        sb.append("    addr: ").append(this.toIndentedString(this.addr)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    targetConf: ").append(this.toIndentedString(this.targetConf)).append("\n");
        sb.append("    satPerVbyte: ").append(this.toIndentedString(this.satPerVbyte)).append("\n");
        sb.append("    satPerByte: ").append(this.toIndentedString(this.satPerByte)).append("\n");
        sb.append("    sendAll: ").append(this.toIndentedString(this.sendAll)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    minConfs: ").append(this.toIndentedString(this.minConfs)).append("\n");
        sb.append("    spendUnconfirmed: ").append(this.toIndentedString(this.spendUnconfirmed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

