/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcHop;

@ApiModel(description="A path through the channel graph which runs over one or more channels in succession. This struct carries all the information required to craft the Sphinx onion packet, and send the payment along the first hop in the path. A route is only selected as valid if all the channels have sufficient capacity to carry the initial payment amount after fees are accounted for.")
public class LnrpcRoute {
    public static final String SERIALIZED_NAME_TOTAL_TIME_LOCK = "total_time_lock";
    @SerializedName(value="total_time_lock")
    private Long totalTimeLock;
    public static final String SERIALIZED_NAME_TOTAL_FEES = "total_fees";
    @SerializedName(value="total_fees")
    private String totalFees;
    public static final String SERIALIZED_NAME_TOTAL_AMT = "total_amt";
    @SerializedName(value="total_amt")
    private String totalAmt;
    public static final String SERIALIZED_NAME_HOPS = "hops";
    @SerializedName(value="hops")
    private List<LnrpcHop> hops = null;
    public static final String SERIALIZED_NAME_TOTAL_FEES_MSAT = "total_fees_msat";
    @SerializedName(value="total_fees_msat")
    private String totalFeesMsat;
    public static final String SERIALIZED_NAME_TOTAL_AMT_MSAT = "total_amt_msat";
    @SerializedName(value="total_amt_msat")
    private String totalAmtMsat;

    public LnrpcRoute totalTimeLock(Long totalTimeLock) {
        this.totalTimeLock = totalTimeLock;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The cumulative (final) time lock across the entire route. This is the CLTV value that should be extended to the first hop in the route. All other hops will decrement the time-lock as advertised, leaving enough time for all hops to wait for or present the payment preimage to complete the payment.")
    public Long getTotalTimeLock() {
        return this.totalTimeLock;
    }

    public void setTotalTimeLock(Long totalTimeLock) {
        this.totalTimeLock = totalTimeLock;
    }

    public LnrpcRoute totalFees(String totalFees) {
        this.totalFees = totalFees;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sum of the fees paid at each hop within the final route. In the case of a one-hop payment, this value will be zero as we don't need to pay a fee to ourselves.")
    public String getTotalFees() {
        return this.totalFees;
    }

    public void setTotalFees(String totalFees) {
        this.totalFees = totalFees;
    }

    public LnrpcRoute totalAmt(String totalAmt) {
        this.totalAmt = totalAmt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of funds required to complete a payment over this route. This value includes the cumulative fees at each hop. As a result, the HTLC extended to the first-hop in the route will need to have at least this many satoshis, otherwise the route will fail at an intermediate node due to an insufficient amount of fees.")
    public String getTotalAmt() {
        return this.totalAmt;
    }

    public void setTotalAmt(String totalAmt) {
        this.totalAmt = totalAmt;
    }

    public LnrpcRoute hops(List<LnrpcHop> hops) {
        this.hops = hops;
        return this;
    }

    public LnrpcRoute addHopsItem(LnrpcHop hopsItem) {
        if (this.hops == null) {
            this.hops = new ArrayList<LnrpcHop>();
        }
        this.hops.add(hopsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains details concerning the specific forwarding details at each hop.")
    public List<LnrpcHop> getHops() {
        return this.hops;
    }

    public void setHops(List<LnrpcHop> hops) {
        this.hops = hops;
    }

    public LnrpcRoute totalFeesMsat(String totalFeesMsat) {
        this.totalFeesMsat = totalFeesMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total fees in millisatoshis.")
    public String getTotalFeesMsat() {
        return this.totalFeesMsat;
    }

    public void setTotalFeesMsat(String totalFeesMsat) {
        this.totalFeesMsat = totalFeesMsat;
    }

    public LnrpcRoute totalAmtMsat(String totalAmtMsat) {
        this.totalAmtMsat = totalAmtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount in millisatoshis.")
    public String getTotalAmtMsat() {
        return this.totalAmtMsat;
    }

    public void setTotalAmtMsat(String totalAmtMsat) {
        this.totalAmtMsat = totalAmtMsat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcRoute lnrpcRoute = (LnrpcRoute)o;
        return Objects.equals(this.totalTimeLock, lnrpcRoute.totalTimeLock) && Objects.equals(this.totalFees, lnrpcRoute.totalFees) && Objects.equals(this.totalAmt, lnrpcRoute.totalAmt) && Objects.equals(this.hops, lnrpcRoute.hops) && Objects.equals(this.totalFeesMsat, lnrpcRoute.totalFeesMsat) && Objects.equals(this.totalAmtMsat, lnrpcRoute.totalAmtMsat);
    }

    public int hashCode() {
        return Objects.hash(this.totalTimeLock, this.totalFees, this.totalAmt, this.hops, this.totalFeesMsat, this.totalAmtMsat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcRoute {\n");
        sb.append("    totalTimeLock: ").append(this.toIndentedString(this.totalTimeLock)).append("\n");
        sb.append("    totalFees: ").append(this.toIndentedString(this.totalFees)).append("\n");
        sb.append("    totalAmt: ").append(this.toIndentedString(this.totalAmt)).append("\n");
        sb.append("    hops: ").append(this.toIndentedString(this.hops)).append("\n");
        sb.append("    totalFeesMsat: ").append(this.toIndentedString(this.totalFeesMsat)).append("\n");
        sb.append("    totalAmtMsat: ").append(this.toIndentedString(this.totalAmtMsat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

