/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcReadyForPsbtFunding {
    public static final String SERIALIZED_NAME_FUNDING_ADDRESS = "funding_address";
    @SerializedName(value="funding_address")
    private String fundingAddress;
    public static final String SERIALIZED_NAME_FUNDING_AMOUNT = "funding_amount";
    @SerializedName(value="funding_amount")
    private String fundingAmount;
    public static final String SERIALIZED_NAME_PSBT = "psbt";
    @SerializedName(value="psbt")
    private byte[] psbt;

    public LnrpcReadyForPsbtFunding fundingAddress(String fundingAddress) {
        this.fundingAddress = fundingAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The P2WSH address of the channel funding multisig address that the below specified amount in satoshis needs to be sent to.")
    public String getFundingAddress() {
        return this.fundingAddress;
    }

    public void setFundingAddress(String fundingAddress) {
        this.fundingAddress = fundingAddress;
    }

    public LnrpcReadyForPsbtFunding fundingAmount(String fundingAmount) {
        this.fundingAmount = fundingAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The exact amount in satoshis that needs to be sent to the above address to fund the pending channel.")
    public String getFundingAmount() {
        return this.fundingAmount;
    }

    public void setFundingAmount(String fundingAmount) {
        this.fundingAmount = fundingAmount;
    }

    public LnrpcReadyForPsbtFunding psbt(byte[] psbt) {
        this.psbt = psbt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A raw PSBT that contains the pending channel output. If a base PSBT was provided in the PsbtShim, this is the base PSBT with one additional output. If no base PSBT was specified, this is an otherwise empty PSBT with exactly one output.")
    public byte[] getPsbt() {
        return this.psbt;
    }

    public void setPsbt(byte[] psbt) {
        this.psbt = psbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcReadyForPsbtFunding lnrpcReadyForPsbtFunding = (LnrpcReadyForPsbtFunding)o;
        return Objects.equals(this.fundingAddress, lnrpcReadyForPsbtFunding.fundingAddress) && Objects.equals(this.fundingAmount, lnrpcReadyForPsbtFunding.fundingAmount) && Arrays.equals(this.psbt, lnrpcReadyForPsbtFunding.psbt);
    }

    public int hashCode() {
        return Objects.hash(this.fundingAddress, this.fundingAmount, Arrays.hashCode(this.psbt));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcReadyForPsbtFunding {\n");
        sb.append("    fundingAddress: ").append(this.toIndentedString(this.fundingAddress)).append("\n");
        sb.append("    fundingAmount: ").append(this.toIndentedString(this.fundingAmount)).append("\n");
        sb.append("    psbt: ").append(this.toIndentedString(this.psbt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

