/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcRPCMessage;
import net.osslabz.lnd.dto.LnrpcStreamAuth;

public class LnrpcRPCMiddlewareRequest {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_RAW_MACAROON = "raw_macaroon";
    @SerializedName(value="raw_macaroon")
    private byte[] rawMacaroon;
    public static final String SERIALIZED_NAME_CUSTOM_CAVEAT_CONDITION = "custom_caveat_condition";
    @SerializedName(value="custom_caveat_condition")
    private String customCaveatCondition;
    public static final String SERIALIZED_NAME_STREAM_AUTH = "stream_auth";
    @SerializedName(value="stream_auth")
    private LnrpcStreamAuth streamAuth;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private LnrpcRPCMessage request;
    public static final String SERIALIZED_NAME_RESPONSE = "response";
    @SerializedName(value="response")
    private LnrpcRPCMessage response;
    public static final String SERIALIZED_NAME_REG_COMPLETE = "reg_complete";
    @SerializedName(value="reg_complete")
    private Boolean regComplete;
    public static final String SERIALIZED_NAME_MSG_ID = "msg_id";
    @SerializedName(value="msg_id")
    private String msgId;

    public LnrpcRPCMiddlewareRequest requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of the intercepted original gRPC request. Useful for mapping request to response when implementing full duplex message interception. For streaming requests, this will be the same ID for all incoming and outgoing middleware intercept messages of the _same_ stream.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LnrpcRPCMiddlewareRequest rawMacaroon(byte[] rawMacaroon) {
        this.rawMacaroon = rawMacaroon;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The raw bytes of the complete macaroon as sent by the gRPC client in the original request. This might be empty for a request that doesn't require macaroons such as the wallet unlocker RPCs.")
    public byte[] getRawMacaroon() {
        return this.rawMacaroon;
    }

    public void setRawMacaroon(byte[] rawMacaroon) {
        this.rawMacaroon = rawMacaroon;
    }

    public LnrpcRPCMiddlewareRequest customCaveatCondition(String customCaveatCondition) {
        this.customCaveatCondition = customCaveatCondition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCustomCaveatCondition() {
        return this.customCaveatCondition;
    }

    public void setCustomCaveatCondition(String customCaveatCondition) {
        this.customCaveatCondition = customCaveatCondition;
    }

    public LnrpcRPCMiddlewareRequest streamAuth(LnrpcStreamAuth streamAuth) {
        this.streamAuth = streamAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcStreamAuth getStreamAuth() {
        return this.streamAuth;
    }

    public void setStreamAuth(LnrpcStreamAuth streamAuth) {
        this.streamAuth = streamAuth;
    }

    public LnrpcRPCMiddlewareRequest request(LnrpcRPCMessage request) {
        this.request = request;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRPCMessage getRequest() {
        return this.request;
    }

    public void setRequest(LnrpcRPCMessage request) {
        this.request = request;
    }

    public LnrpcRPCMiddlewareRequest response(LnrpcRPCMessage response) {
        this.response = response;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcRPCMessage getResponse() {
        return this.response;
    }

    public void setResponse(LnrpcRPCMessage response) {
        this.response = response;
    }

    public LnrpcRPCMiddlewareRequest regComplete(Boolean regComplete) {
        this.regComplete = regComplete;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This is used to indicate to the client that the server has successfully registered the interceptor. This is only used in the very first message that the server sends to the client after the client sends the server the middleware registration message.")
    public Boolean getRegComplete() {
        return this.regComplete;
    }

    public void setRegComplete(Boolean regComplete) {
        this.regComplete = regComplete;
    }

    public LnrpcRPCMiddlewareRequest msgId(String msgId) {
        this.msgId = msgId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique message ID of this middleware intercept message. There can be multiple middleware intercept messages per single gRPC request (one for the incoming request and one for the outgoing response) or gRPC stream (one for each incoming message and one for each outgoing response). This message ID must be referenced when responding (accepting/rejecting/modifying) to an intercept message.")
    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcRPCMiddlewareRequest lnrpcRPCMiddlewareRequest = (LnrpcRPCMiddlewareRequest)o;
        return Objects.equals(this.requestId, lnrpcRPCMiddlewareRequest.requestId) && Arrays.equals(this.rawMacaroon, lnrpcRPCMiddlewareRequest.rawMacaroon) && Objects.equals(this.customCaveatCondition, lnrpcRPCMiddlewareRequest.customCaveatCondition) && Objects.equals(this.streamAuth, lnrpcRPCMiddlewareRequest.streamAuth) && Objects.equals(this.request, lnrpcRPCMiddlewareRequest.request) && Objects.equals(this.response, lnrpcRPCMiddlewareRequest.response) && Objects.equals(this.regComplete, lnrpcRPCMiddlewareRequest.regComplete) && Objects.equals(this.msgId, lnrpcRPCMiddlewareRequest.msgId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, Arrays.hashCode(this.rawMacaroon), this.customCaveatCondition, this.streamAuth, this.request, this.response, this.regComplete, this.msgId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcRPCMiddlewareRequest {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    rawMacaroon: ").append(this.toIndentedString(this.rawMacaroon)).append("\n");
        sb.append("    customCaveatCondition: ").append(this.toIndentedString(this.customCaveatCondition)).append("\n");
        sb.append("    streamAuth: ").append(this.toIndentedString(this.streamAuth)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    response: ").append(this.toIndentedString(this.response)).append("\n");
        sb.append("    regComplete: ").append(this.toIndentedString(this.regComplete)).append("\n");
        sb.append("    msgId: ").append(this.toIndentedString(this.msgId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

