/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcRPCMessage {
    public static final String SERIALIZED_NAME_METHOD_FULL_URI = "method_full_uri";
    @SerializedName(value="method_full_uri")
    private String methodFullUri;
    public static final String SERIALIZED_NAME_STREAM_RPC = "stream_rpc";
    @SerializedName(value="stream_rpc")
    private Boolean streamRpc;
    public static final String SERIALIZED_NAME_TYPE_NAME = "type_name";
    @SerializedName(value="type_name")
    private String typeName;
    public static final String SERIALIZED_NAME_SERIALIZED = "serialized";
    @SerializedName(value="serialized")
    private byte[] serialized;
    public static final String SERIALIZED_NAME_IS_ERROR = "is_error";
    @SerializedName(value="is_error")
    private Boolean isError;

    public LnrpcRPCMessage methodFullUri(String methodFullUri) {
        this.methodFullUri = methodFullUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full URI (in the format /<rpcpackage>.<ServiceName>/MethodName, for example /lnrpc.Lightning/GetInfo) of the RPC method the message was sent to/from.")
    public String getMethodFullUri() {
        return this.methodFullUri;
    }

    public void setMethodFullUri(String methodFullUri) {
        this.methodFullUri = methodFullUri;
    }

    public LnrpcRPCMessage streamRpc(Boolean streamRpc) {
        this.streamRpc = streamRpc;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the message was sent over a streaming RPC method or not.")
    public Boolean getStreamRpc() {
        return this.streamRpc;
    }

    public void setStreamRpc(Boolean streamRpc) {
        this.streamRpc = streamRpc;
    }

    public LnrpcRPCMessage typeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full canonical gRPC name of the message type (in the format <rpcpackage>.TypeName, for example lnrpc.GetInfoRequest). In case of an error being returned from lnd, this simply contains the string \"error\".")
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public LnrpcRPCMessage serialized(byte[] serialized) {
        this.serialized = serialized;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full content of the gRPC message, serialized in the binary protobuf format.")
    public byte[] getSerialized() {
        return this.serialized;
    }

    public void setSerialized(byte[] serialized) {
        this.serialized = serialized;
    }

    public LnrpcRPCMessage isError(Boolean isError) {
        this.isError = isError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the response from lnd was an error, not a gRPC response. If this is set to true then the type_name contains the string \"error\" and serialized contains the error string.")
    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcRPCMessage lnrpcRPCMessage = (LnrpcRPCMessage)o;
        return Objects.equals(this.methodFullUri, lnrpcRPCMessage.methodFullUri) && Objects.equals(this.streamRpc, lnrpcRPCMessage.streamRpc) && Objects.equals(this.typeName, lnrpcRPCMessage.typeName) && Arrays.equals(this.serialized, lnrpcRPCMessage.serialized) && Objects.equals(this.isError, lnrpcRPCMessage.isError);
    }

    public int hashCode() {
        return Objects.hash(this.methodFullUri, this.streamRpc, this.typeName, Arrays.hashCode(this.serialized), this.isError);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcRPCMessage {\n");
        sb.append("    methodFullUri: ").append(this.toIndentedString(this.methodFullUri)).append("\n");
        sb.append("    streamRpc: ").append(this.toIndentedString(this.streamRpc)).append("\n");
        sb.append("    typeName: ").append(this.toIndentedString(this.typeName)).append("\n");
        sb.append("    serialized: ").append(this.toIndentedString(this.serialized)).append("\n");
        sb.append("    isError: ").append(this.toIndentedString(this.isError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

