/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcPsbtShim {
    public static final String SERIALIZED_NAME_PENDING_CHAN_ID = "pending_chan_id";
    @SerializedName(value="pending_chan_id")
    private byte[] pendingChanId;
    public static final String SERIALIZED_NAME_BASE_PSBT = "base_psbt";
    @SerializedName(value="base_psbt")
    private byte[] basePsbt;
    public static final String SERIALIZED_NAME_NO_PUBLISH = "no_publish";
    @SerializedName(value="no_publish")
    private Boolean noPublish;

    public LnrpcPsbtShim pendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique identifier of 32 random bytes that will be used as the pending channel ID to identify the PSBT state machine when interacting with it and on the wire protocol to initiate the funding request.")
    public byte[] getPendingChanId() {
        return this.pendingChanId;
    }

    public void setPendingChanId(byte[] pendingChanId) {
        this.pendingChanId = pendingChanId;
    }

    public LnrpcPsbtShim basePsbt(byte[] basePsbt) {
        this.basePsbt = basePsbt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional base PSBT the new channel output will be added to. If this is non-empty, it must be a binary serialized PSBT.")
    public byte[] getBasePsbt() {
        return this.basePsbt;
    }

    public void setBasePsbt(byte[] basePsbt) {
        this.basePsbt = basePsbt;
    }

    public LnrpcPsbtShim noPublish(Boolean noPublish) {
        this.noPublish = noPublish;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If a channel should be part of a batch (multiple channel openings in one transaction), it can be dangerous if the whole batch transaction is published too early before all channel opening negotiations are completed. This flag prevents this particular channel from broadcasting the transaction after the negotiation with the remote peer. In a batch of channel openings this flag should be set to true for every channel but the very last.")
    public Boolean getNoPublish() {
        return this.noPublish;
    }

    public void setNoPublish(Boolean noPublish) {
        this.noPublish = noPublish;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcPsbtShim lnrpcPsbtShim = (LnrpcPsbtShim)o;
        return Arrays.equals(this.pendingChanId, lnrpcPsbtShim.pendingChanId) && Arrays.equals(this.basePsbt, lnrpcPsbtShim.basePsbt) && Objects.equals(this.noPublish, lnrpcPsbtShim.noPublish);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.pendingChanId), Arrays.hashCode(this.basePsbt), this.noPublish);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcPsbtShim {\n");
        sb.append("    pendingChanId: ").append(this.toIndentedString(this.pendingChanId)).append("\n");
        sb.append("    basePsbt: ").append(this.toIndentedString(this.basePsbt)).append("\n");
        sb.append("    noPublish: ").append(this.toIndentedString(this.noPublish)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

