/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelPoint;

public class LnrpcPolicyUpdateRequest {
    public static final String SERIALIZED_NAME_GLOBAL = "global";
    @SerializedName(value="global")
    private Boolean global;
    public static final String SERIALIZED_NAME_CHAN_POINT = "chan_point";
    @SerializedName(value="chan_point")
    private LnrpcChannelPoint chanPoint;
    public static final String SERIALIZED_NAME_BASE_FEE_MSAT = "base_fee_msat";
    @SerializedName(value="base_fee_msat")
    private String baseFeeMsat;
    public static final String SERIALIZED_NAME_FEE_RATE = "fee_rate";
    @SerializedName(value="fee_rate")
    private Double feeRate;
    public static final String SERIALIZED_NAME_FEE_RATE_PPM = "fee_rate_ppm";
    @SerializedName(value="fee_rate_ppm")
    private Long feeRatePpm;
    public static final String SERIALIZED_NAME_TIME_LOCK_DELTA = "time_lock_delta";
    @SerializedName(value="time_lock_delta")
    private Long timeLockDelta;
    public static final String SERIALIZED_NAME_MAX_HTLC_MSAT = "max_htlc_msat";
    @SerializedName(value="max_htlc_msat")
    private String maxHtlcMsat;
    public static final String SERIALIZED_NAME_MIN_HTLC_MSAT = "min_htlc_msat";
    @SerializedName(value="min_htlc_msat")
    private String minHtlcMsat;
    public static final String SERIALIZED_NAME_MIN_HTLC_MSAT_SPECIFIED = "min_htlc_msat_specified";
    @SerializedName(value="min_htlc_msat_specified")
    private Boolean minHtlcMsatSpecified;

    public LnrpcPolicyUpdateRequest global(Boolean global) {
        this.global = global;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, then this update applies to all currently active channels.")
    public Boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public LnrpcPolicyUpdateRequest chanPoint(LnrpcChannelPoint chanPoint) {
        this.chanPoint = chanPoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcChannelPoint getChanPoint() {
        return this.chanPoint;
    }

    public void setChanPoint(LnrpcChannelPoint chanPoint) {
        this.chanPoint = chanPoint;
    }

    public LnrpcPolicyUpdateRequest baseFeeMsat(String baseFeeMsat) {
        this.baseFeeMsat = baseFeeMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base fee charged regardless of the number of milli-satoshis sent.")
    public String getBaseFeeMsat() {
        return this.baseFeeMsat;
    }

    public void setBaseFeeMsat(String baseFeeMsat) {
        this.baseFeeMsat = baseFeeMsat;
    }

    public LnrpcPolicyUpdateRequest feeRate(Double feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The effective fee rate in milli-satoshis. The precision of this value goes up to 6 decimal places, so 1e-6.")
    public Double getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(Double feeRate) {
        this.feeRate = feeRate;
    }

    public LnrpcPolicyUpdateRequest feeRatePpm(Long feeRatePpm) {
        this.feeRatePpm = feeRatePpm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The effective fee rate in micro-satoshis (parts per million).")
    public Long getFeeRatePpm() {
        return this.feeRatePpm;
    }

    public void setFeeRatePpm(Long feeRatePpm) {
        this.feeRatePpm = feeRatePpm;
    }

    public LnrpcPolicyUpdateRequest timeLockDelta(Long timeLockDelta) {
        this.timeLockDelta = timeLockDelta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The required timelock delta for HTLCs forwarded over the channel.")
    public Long getTimeLockDelta() {
        return this.timeLockDelta;
    }

    public void setTimeLockDelta(Long timeLockDelta) {
        this.timeLockDelta = timeLockDelta;
    }

    public LnrpcPolicyUpdateRequest maxHtlcMsat(String maxHtlcMsat) {
        this.maxHtlcMsat = maxHtlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set, the maximum HTLC size in milli-satoshis. If unset, the maximum HTLC will be unchanged.")
    public String getMaxHtlcMsat() {
        return this.maxHtlcMsat;
    }

    public void setMaxHtlcMsat(String maxHtlcMsat) {
        this.maxHtlcMsat = maxHtlcMsat;
    }

    public LnrpcPolicyUpdateRequest minHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum HTLC size in milli-satoshis. Only applied if min_htlc_msat_specified is true.")
    public String getMinHtlcMsat() {
        return this.minHtlcMsat;
    }

    public void setMinHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
    }

    public LnrpcPolicyUpdateRequest minHtlcMsatSpecified(Boolean minHtlcMsatSpecified) {
        this.minHtlcMsatSpecified = minHtlcMsatSpecified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, min_htlc_msat is applied.")
    public Boolean getMinHtlcMsatSpecified() {
        return this.minHtlcMsatSpecified;
    }

    public void setMinHtlcMsatSpecified(Boolean minHtlcMsatSpecified) {
        this.minHtlcMsatSpecified = minHtlcMsatSpecified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcPolicyUpdateRequest lnrpcPolicyUpdateRequest = (LnrpcPolicyUpdateRequest)o;
        return Objects.equals(this.global, lnrpcPolicyUpdateRequest.global) && Objects.equals(this.chanPoint, lnrpcPolicyUpdateRequest.chanPoint) && Objects.equals(this.baseFeeMsat, lnrpcPolicyUpdateRequest.baseFeeMsat) && Objects.equals(this.feeRate, lnrpcPolicyUpdateRequest.feeRate) && Objects.equals(this.feeRatePpm, lnrpcPolicyUpdateRequest.feeRatePpm) && Objects.equals(this.timeLockDelta, lnrpcPolicyUpdateRequest.timeLockDelta) && Objects.equals(this.maxHtlcMsat, lnrpcPolicyUpdateRequest.maxHtlcMsat) && Objects.equals(this.minHtlcMsat, lnrpcPolicyUpdateRequest.minHtlcMsat) && Objects.equals(this.minHtlcMsatSpecified, lnrpcPolicyUpdateRequest.minHtlcMsatSpecified);
    }

    public int hashCode() {
        return Objects.hash(this.global, this.chanPoint, this.baseFeeMsat, this.feeRate, this.feeRatePpm, this.timeLockDelta, this.maxHtlcMsat, this.minHtlcMsat, this.minHtlcMsatSpecified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcPolicyUpdateRequest {\n");
        sb.append("    global: ").append(this.toIndentedString(this.global)).append("\n");
        sb.append("    chanPoint: ").append(this.toIndentedString(this.chanPoint)).append("\n");
        sb.append("    baseFeeMsat: ").append(this.toIndentedString(this.baseFeeMsat)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    feeRatePpm: ").append(this.toIndentedString(this.feeRatePpm)).append("\n");
        sb.append("    timeLockDelta: ").append(this.toIndentedString(this.timeLockDelta)).append("\n");
        sb.append("    maxHtlcMsat: ").append(this.toIndentedString(this.maxHtlcMsat)).append("\n");
        sb.append("    minHtlcMsat: ").append(this.toIndentedString(this.minHtlcMsat)).append("\n");
        sb.append("    minHtlcMsatSpecified: ").append(this.toIndentedString(this.minHtlcMsatSpecified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

