/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcFeature;
import net.osslabz.lnd.dto.LnrpcTimestampedError;
import net.osslabz.lnd.dto.PeerSyncType;

public class LnrpcPeer {
    public static final String SERIALIZED_NAME_PUB_KEY = "pub_key";
    @SerializedName(value="pub_key")
    private String pubKey;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private String address;
    public static final String SERIALIZED_NAME_BYTES_SENT = "bytes_sent";
    @SerializedName(value="bytes_sent")
    private String bytesSent;
    public static final String SERIALIZED_NAME_BYTES_RECV = "bytes_recv";
    @SerializedName(value="bytes_recv")
    private String bytesRecv;
    public static final String SERIALIZED_NAME_SAT_SENT = "sat_sent";
    @SerializedName(value="sat_sent")
    private String satSent;
    public static final String SERIALIZED_NAME_SAT_RECV = "sat_recv";
    @SerializedName(value="sat_recv")
    private String satRecv;
    public static final String SERIALIZED_NAME_INBOUND = "inbound";
    @SerializedName(value="inbound")
    private Boolean inbound;
    public static final String SERIALIZED_NAME_PING_TIME = "ping_time";
    @SerializedName(value="ping_time")
    private String pingTime;
    public static final String SERIALIZED_NAME_SYNC_TYPE = "sync_type";
    @SerializedName(value="sync_type")
    private PeerSyncType syncType = PeerSyncType.UNKNOWN_SYNC;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, LnrpcFeature> features = null;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<LnrpcTimestampedError> errors = null;
    public static final String SERIALIZED_NAME_FLAP_COUNT = "flap_count";
    @SerializedName(value="flap_count")
    private Integer flapCount;
    public static final String SERIALIZED_NAME_LAST_FLAP_NS = "last_flap_ns";
    @SerializedName(value="last_flap_ns")
    private String lastFlapNs;
    public static final String SERIALIZED_NAME_LAST_PING_PAYLOAD = "last_ping_payload";
    @SerializedName(value="last_ping_payload")
    private byte[] lastPingPayload;

    public LnrpcPeer pubKey(String pubKey) {
        this.pubKey = pubKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public LnrpcPeer address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LnrpcPeer bytesSent(String bytesSent) {
        this.bytesSent = bytesSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(String bytesSent) {
        this.bytesSent = bytesSent;
    }

    public LnrpcPeer bytesRecv(String bytesRecv) {
        this.bytesRecv = bytesRecv;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(String bytesRecv) {
        this.bytesRecv = bytesRecv;
    }

    public LnrpcPeer satSent(String satSent) {
        this.satSent = satSent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSatSent() {
        return this.satSent;
    }

    public void setSatSent(String satSent) {
        this.satSent = satSent;
    }

    public LnrpcPeer satRecv(String satRecv) {
        this.satRecv = satRecv;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSatRecv() {
        return this.satRecv;
    }

    public void setSatRecv(String satRecv) {
        this.satRecv = satRecv;
    }

    public LnrpcPeer inbound(Boolean inbound) {
        this.inbound = inbound;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getInbound() {
        return this.inbound;
    }

    public void setInbound(Boolean inbound) {
        this.inbound = inbound;
    }

    public LnrpcPeer pingTime(String pingTime) {
        this.pingTime = pingTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPingTime() {
        return this.pingTime;
    }

    public void setPingTime(String pingTime) {
        this.pingTime = pingTime;
    }

    public LnrpcPeer syncType(PeerSyncType syncType) {
        this.syncType = syncType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PeerSyncType getSyncType() {
        return this.syncType;
    }

    public void setSyncType(PeerSyncType syncType) {
        this.syncType = syncType;
    }

    public LnrpcPeer features(Map<String, LnrpcFeature> features) {
        this.features = features;
        return this;
    }

    public LnrpcPeer putFeaturesItem(String key, LnrpcFeature featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, LnrpcFeature>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Features advertised by the remote peer in their init message.")
    public Map<String, LnrpcFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, LnrpcFeature> features) {
        this.features = features;
    }

    public LnrpcPeer errors(List<LnrpcTimestampedError> errors) {
        this.errors = errors;
        return this;
    }

    public LnrpcPeer addErrorsItem(LnrpcTimestampedError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<LnrpcTimestampedError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest errors received from our peer with timestamps, limited to the 10 most recent errors. These errors are tracked across peer connections, but are not persisted across lnd restarts. Note that these errors are only stored for peers that we have channels open with, to prevent peers from spamming us with errors at no cost.")
    public List<LnrpcTimestampedError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<LnrpcTimestampedError> errors) {
        this.errors = errors;
    }

    public LnrpcPeer flapCount(Integer flapCount) {
        this.flapCount = flapCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times we have recorded this peer going offline or coming online, recorded across restarts. Note that this value is decreased over time if the peer has not recently flapped, so that we can forgive peers with historically high flap counts.")
    public Integer getFlapCount() {
        return this.flapCount;
    }

    public void setFlapCount(Integer flapCount) {
        this.flapCount = flapCount;
    }

    public LnrpcPeer lastFlapNs(String lastFlapNs) {
        this.lastFlapNs = lastFlapNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timestamp of the last flap we observed for this peer. If this value is zero, we have not observed any flaps for this peer.")
    public String getLastFlapNs() {
        return this.lastFlapNs;
    }

    public void setLastFlapNs(String lastFlapNs) {
        this.lastFlapNs = lastFlapNs;
    }

    public LnrpcPeer lastPingPayload(byte[] lastPingPayload) {
        this.lastPingPayload = lastPingPayload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last ping payload the peer has sent to us.")
    public byte[] getLastPingPayload() {
        return this.lastPingPayload;
    }

    public void setLastPingPayload(byte[] lastPingPayload) {
        this.lastPingPayload = lastPingPayload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcPeer lnrpcPeer = (LnrpcPeer)o;
        return Objects.equals(this.pubKey, lnrpcPeer.pubKey) && Objects.equals(this.address, lnrpcPeer.address) && Objects.equals(this.bytesSent, lnrpcPeer.bytesSent) && Objects.equals(this.bytesRecv, lnrpcPeer.bytesRecv) && Objects.equals(this.satSent, lnrpcPeer.satSent) && Objects.equals(this.satRecv, lnrpcPeer.satRecv) && Objects.equals(this.inbound, lnrpcPeer.inbound) && Objects.equals(this.pingTime, lnrpcPeer.pingTime) && Objects.equals((Object)this.syncType, (Object)lnrpcPeer.syncType) && Objects.equals(this.features, lnrpcPeer.features) && Objects.equals(this.errors, lnrpcPeer.errors) && Objects.equals(this.flapCount, lnrpcPeer.flapCount) && Objects.equals(this.lastFlapNs, lnrpcPeer.lastFlapNs) && Arrays.equals(this.lastPingPayload, lnrpcPeer.lastPingPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pubKey, this.address, this.bytesSent, this.bytesRecv, this.satSent, this.satRecv, this.inbound, this.pingTime, this.syncType, this.features, this.errors, this.flapCount, this.lastFlapNs, Arrays.hashCode(this.lastPingPayload)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcPeer {\n");
        sb.append("    pubKey: ").append(this.toIndentedString(this.pubKey)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    bytesSent: ").append(this.toIndentedString(this.bytesSent)).append("\n");
        sb.append("    bytesRecv: ").append(this.toIndentedString(this.bytesRecv)).append("\n");
        sb.append("    satSent: ").append(this.toIndentedString(this.satSent)).append("\n");
        sb.append("    satRecv: ").append(this.toIndentedString(this.satRecv)).append("\n");
        sb.append("    inbound: ").append(this.toIndentedString(this.inbound)).append("\n");
        sb.append("    pingTime: ").append(this.toIndentedString(this.pingTime)).append("\n");
        sb.append("    syncType: ").append(this.toIndentedString((Object)this.syncType)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    flapCount: ").append(this.toIndentedString(this.flapCount)).append("\n");
        sb.append("    lastFlapNs: ").append(this.toIndentedString(this.lastFlapNs)).append("\n");
        sb.append("    lastPingPayload: ").append(this.toIndentedString(this.lastPingPayload)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

