/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcHTLCAttempt;
import net.osslabz.lnd.dto.LnrpcPaymentFailureReason;
import net.osslabz.lnd.dto.PaymentPaymentStatus;

public class LnrpcPayment {
    public static final String SERIALIZED_NAME_PAYMENT_HASH = "payment_hash";
    @SerializedName(value="payment_hash")
    private String paymentHash;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private String creationDate;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private String fee;
    public static final String SERIALIZED_NAME_PAYMENT_PREIMAGE = "payment_preimage";
    @SerializedName(value="payment_preimage")
    private String paymentPreimage;
    public static final String SERIALIZED_NAME_VALUE_SAT = "value_sat";
    @SerializedName(value="value_sat")
    private String valueSat;
    public static final String SERIALIZED_NAME_VALUE_MSAT = "value_msat";
    @SerializedName(value="value_msat")
    private String valueMsat;
    public static final String SERIALIZED_NAME_PAYMENT_REQUEST = "payment_request";
    @SerializedName(value="payment_request")
    private String paymentRequest;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private PaymentPaymentStatus status = PaymentPaymentStatus.UNKNOWN;
    public static final String SERIALIZED_NAME_FEE_SAT = "fee_sat";
    @SerializedName(value="fee_sat")
    private String feeSat;
    public static final String SERIALIZED_NAME_FEE_MSAT = "fee_msat";
    @SerializedName(value="fee_msat")
    private String feeMsat;
    public static final String SERIALIZED_NAME_CREATION_TIME_NS = "creation_time_ns";
    @SerializedName(value="creation_time_ns")
    private String creationTimeNs;
    public static final String SERIALIZED_NAME_HTLCS = "htlcs";
    @SerializedName(value="htlcs")
    private List<LnrpcHTLCAttempt> htlcs = null;
    public static final String SERIALIZED_NAME_PAYMENT_INDEX = "payment_index";
    @SerializedName(value="payment_index")
    private String paymentIndex;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private LnrpcPaymentFailureReason failureReason = LnrpcPaymentFailureReason.NONE;

    public LnrpcPayment paymentHash(String paymentHash) {
        this.paymentHash = paymentHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPaymentHash() {
        return this.paymentHash;
    }

    public void setPaymentHash(String paymentHash) {
        this.paymentHash = paymentHash;
    }

    public LnrpcPayment value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use value_sat or value_msat.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LnrpcPayment creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public LnrpcPayment fee(String fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use fee_sat or fee_msat.")
    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public LnrpcPayment paymentPreimage(String paymentPreimage) {
        this.paymentPreimage = paymentPreimage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPaymentPreimage() {
        return this.paymentPreimage;
    }

    public void setPaymentPreimage(String paymentPreimage) {
        this.paymentPreimage = paymentPreimage;
    }

    public LnrpcPayment valueSat(String valueSat) {
        this.valueSat = valueSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getValueSat() {
        return this.valueSat;
    }

    public void setValueSat(String valueSat) {
        this.valueSat = valueSat;
    }

    public LnrpcPayment valueMsat(String valueMsat) {
        this.valueMsat = valueMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getValueMsat() {
        return this.valueMsat;
    }

    public void setValueMsat(String valueMsat) {
        this.valueMsat = valueMsat;
    }

    public LnrpcPayment paymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional payment request being fulfilled.")
    public String getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public LnrpcPayment status(PaymentPaymentStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentPaymentStatus getStatus() {
        return this.status;
    }

    public void setStatus(PaymentPaymentStatus status) {
        this.status = status;
    }

    public LnrpcPayment feeSat(String feeSat) {
        this.feeSat = feeSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFeeSat() {
        return this.feeSat;
    }

    public void setFeeSat(String feeSat) {
        this.feeSat = feeSat;
    }

    public LnrpcPayment feeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFeeMsat() {
        return this.feeMsat;
    }

    public void setFeeMsat(String feeMsat) {
        this.feeMsat = feeMsat;
    }

    public LnrpcPayment creationTimeNs(String creationTimeNs) {
        this.creationTimeNs = creationTimeNs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time in UNIX nanoseconds at which the payment was created.")
    public String getCreationTimeNs() {
        return this.creationTimeNs;
    }

    public void setCreationTimeNs(String creationTimeNs) {
        this.creationTimeNs = creationTimeNs;
    }

    public LnrpcPayment htlcs(List<LnrpcHTLCAttempt> htlcs) {
        this.htlcs = htlcs;
        return this;
    }

    public LnrpcPayment addHtlcsItem(LnrpcHTLCAttempt htlcsItem) {
        if (this.htlcs == null) {
            this.htlcs = new ArrayList<LnrpcHTLCAttempt>();
        }
        this.htlcs.add(htlcsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The HTLCs made in attempt to settle the payment.")
    public List<LnrpcHTLCAttempt> getHtlcs() {
        return this.htlcs;
    }

    public void setHtlcs(List<LnrpcHTLCAttempt> htlcs) {
        this.htlcs = htlcs;
    }

    public LnrpcPayment paymentIndex(String paymentIndex) {
        this.paymentIndex = paymentIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The creation index of this payment. Each payment can be uniquely identified by this index, which may not strictly increment by 1 for payments made in older versions of lnd.")
    public String getPaymentIndex() {
        return this.paymentIndex;
    }

    public void setPaymentIndex(String paymentIndex) {
        this.paymentIndex = paymentIndex;
    }

    public LnrpcPayment failureReason(LnrpcPaymentFailureReason failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcPaymentFailureReason getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(LnrpcPaymentFailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcPayment lnrpcPayment = (LnrpcPayment)o;
        return Objects.equals(this.paymentHash, lnrpcPayment.paymentHash) && Objects.equals(this.value, lnrpcPayment.value) && Objects.equals(this.creationDate, lnrpcPayment.creationDate) && Objects.equals(this.fee, lnrpcPayment.fee) && Objects.equals(this.paymentPreimage, lnrpcPayment.paymentPreimage) && Objects.equals(this.valueSat, lnrpcPayment.valueSat) && Objects.equals(this.valueMsat, lnrpcPayment.valueMsat) && Objects.equals(this.paymentRequest, lnrpcPayment.paymentRequest) && Objects.equals((Object)this.status, (Object)lnrpcPayment.status) && Objects.equals(this.feeSat, lnrpcPayment.feeSat) && Objects.equals(this.feeMsat, lnrpcPayment.feeMsat) && Objects.equals(this.creationTimeNs, lnrpcPayment.creationTimeNs) && Objects.equals(this.htlcs, lnrpcPayment.htlcs) && Objects.equals(this.paymentIndex, lnrpcPayment.paymentIndex) && Objects.equals((Object)this.failureReason, (Object)lnrpcPayment.failureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentHash, this.value, this.creationDate, this.fee, this.paymentPreimage, this.valueSat, this.valueMsat, this.paymentRequest, this.status, this.feeSat, this.feeMsat, this.creationTimeNs, this.htlcs, this.paymentIndex, this.failureReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcPayment {\n");
        sb.append("    paymentHash: ").append(this.toIndentedString(this.paymentHash)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    paymentPreimage: ").append(this.toIndentedString(this.paymentPreimage)).append("\n");
        sb.append("    valueSat: ").append(this.toIndentedString(this.valueSat)).append("\n");
        sb.append("    valueMsat: ").append(this.toIndentedString(this.valueMsat)).append("\n");
        sb.append("    paymentRequest: ").append(this.toIndentedString(this.paymentRequest)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    feeSat: ").append(this.toIndentedString(this.feeSat)).append("\n");
        sb.append("    feeMsat: ").append(this.toIndentedString(this.feeMsat)).append("\n");
        sb.append("    creationTimeNs: ").append(this.toIndentedString(this.creationTimeNs)).append("\n");
        sb.append("    htlcs: ").append(this.toIndentedString(this.htlcs)).append("\n");
        sb.append("    paymentIndex: ").append(this.toIndentedString(this.paymentIndex)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString((Object)this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

