/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcOutPoint {
    public static final String SERIALIZED_NAME_TXID_BYTES = "txid_bytes";
    @SerializedName(value="txid_bytes")
    private byte[] txidBytes;
    public static final String SERIALIZED_NAME_TXID_STR = "txid_str";
    @SerializedName(value="txid_str")
    private String txidStr;
    public static final String SERIALIZED_NAME_OUTPUT_INDEX = "output_index";
    @SerializedName(value="output_index")
    private Long outputIndex;

    public LnrpcOutPoint txidBytes(byte[] txidBytes) {
        this.txidBytes = txidBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Raw bytes representing the transaction id.")
    public byte[] getTxidBytes() {
        return this.txidBytes;
    }

    public void setTxidBytes(byte[] txidBytes) {
        this.txidBytes = txidBytes;
    }

    public LnrpcOutPoint txidStr(String txidStr) {
        this.txidStr = txidStr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reversed, hex-encoded string representing the transaction id.")
    public String getTxidStr() {
        return this.txidStr;
    }

    public void setTxidStr(String txidStr) {
        this.txidStr = txidStr;
    }

    public LnrpcOutPoint outputIndex(Long outputIndex) {
        this.outputIndex = outputIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The index of the output on the transaction.")
    public Long getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(Long outputIndex) {
        this.outputIndex = outputIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcOutPoint lnrpcOutPoint = (LnrpcOutPoint)o;
        return Arrays.equals(this.txidBytes, lnrpcOutPoint.txidBytes) && Objects.equals(this.txidStr, lnrpcOutPoint.txidStr) && Objects.equals(this.outputIndex, lnrpcOutPoint.outputIndex);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.txidBytes), this.txidStr, this.outputIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcOutPoint {\n");
        sb.append("    txidBytes: ").append(this.toIndentedString(this.txidBytes)).append("\n");
        sb.append("    txidStr: ").append(this.toIndentedString(this.txidStr)).append("\n");
        sb.append("    outputIndex: ").append(this.toIndentedString(this.outputIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

