/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcCommitmentType;
import net.osslabz.lnd.dto.LnrpcFundingShim;

public class LnrpcOpenChannelRequest {
    public static final String SERIALIZED_NAME_SAT_PER_VBYTE = "sat_per_vbyte";
    @SerializedName(value="sat_per_vbyte")
    private String satPerVbyte;
    public static final String SERIALIZED_NAME_NODE_PUBKEY = "node_pubkey";
    @SerializedName(value="node_pubkey")
    private byte[] nodePubkey;
    public static final String SERIALIZED_NAME_NODE_PUBKEY_STRING = "node_pubkey_string";
    @SerializedName(value="node_pubkey_string")
    private String nodePubkeyString;
    public static final String SERIALIZED_NAME_LOCAL_FUNDING_AMOUNT = "local_funding_amount";
    @SerializedName(value="local_funding_amount")
    private String localFundingAmount;
    public static final String SERIALIZED_NAME_PUSH_SAT = "push_sat";
    @SerializedName(value="push_sat")
    private String pushSat;
    public static final String SERIALIZED_NAME_TARGET_CONF = "target_conf";
    @SerializedName(value="target_conf")
    private Integer targetConf;
    public static final String SERIALIZED_NAME_SAT_PER_BYTE = "sat_per_byte";
    @SerializedName(value="sat_per_byte")
    private String satPerByte;
    public static final String SERIALIZED_NAME_PRIVATE = "private";
    @SerializedName(value="private")
    private Boolean _private;
    public static final String SERIALIZED_NAME_MIN_HTLC_MSAT = "min_htlc_msat";
    @SerializedName(value="min_htlc_msat")
    private String minHtlcMsat;
    public static final String SERIALIZED_NAME_REMOTE_CSV_DELAY = "remote_csv_delay";
    @SerializedName(value="remote_csv_delay")
    private Long remoteCsvDelay;
    public static final String SERIALIZED_NAME_MIN_CONFS = "min_confs";
    @SerializedName(value="min_confs")
    private Integer minConfs;
    public static final String SERIALIZED_NAME_SPEND_UNCONFIRMED = "spend_unconfirmed";
    @SerializedName(value="spend_unconfirmed")
    private Boolean spendUnconfirmed;
    public static final String SERIALIZED_NAME_CLOSE_ADDRESS = "close_address";
    @SerializedName(value="close_address")
    private String closeAddress;
    public static final String SERIALIZED_NAME_FUNDING_SHIM = "funding_shim";
    @SerializedName(value="funding_shim")
    private LnrpcFundingShim fundingShim;
    public static final String SERIALIZED_NAME_REMOTE_MAX_VALUE_IN_FLIGHT_MSAT = "remote_max_value_in_flight_msat";
    @SerializedName(value="remote_max_value_in_flight_msat")
    private String remoteMaxValueInFlightMsat;
    public static final String SERIALIZED_NAME_REMOTE_MAX_HTLCS = "remote_max_htlcs";
    @SerializedName(value="remote_max_htlcs")
    private Long remoteMaxHtlcs;
    public static final String SERIALIZED_NAME_MAX_LOCAL_CSV = "max_local_csv";
    @SerializedName(value="max_local_csv")
    private Long maxLocalCsv;
    public static final String SERIALIZED_NAME_COMMITMENT_TYPE = "commitment_type";
    @SerializedName(value="commitment_type")
    private LnrpcCommitmentType commitmentType = LnrpcCommitmentType.UNKNOWN_COMMITMENT_TYPE;
    public static final String SERIALIZED_NAME_ZERO_CONF = "zero_conf";
    @SerializedName(value="zero_conf")
    private Boolean zeroConf;
    public static final String SERIALIZED_NAME_SCID_ALIAS = "scid_alias";
    @SerializedName(value="scid_alias")
    private Boolean scidAlias;
    public static final String SERIALIZED_NAME_BASE_FEE = "base_fee";
    @SerializedName(value="base_fee")
    private String baseFee;
    public static final String SERIALIZED_NAME_FEE_RATE = "fee_rate";
    @SerializedName(value="fee_rate")
    private String feeRate;
    public static final String SERIALIZED_NAME_USE_BASE_FEE = "use_base_fee";
    @SerializedName(value="use_base_fee")
    private Boolean useBaseFee;
    public static final String SERIALIZED_NAME_USE_FEE_RATE = "use_fee_rate";
    @SerializedName(value="use_fee_rate")
    private Boolean useFeeRate;
    public static final String SERIALIZED_NAME_REMOTE_CHAN_RESERVE_SAT = "remote_chan_reserve_sat";
    @SerializedName(value="remote_chan_reserve_sat")
    private String remoteChanReserveSat;

    public LnrpcOpenChannelRequest satPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A manual fee rate set in sat/vbyte that should be used when crafting the funding transaction.")
    public String getSatPerVbyte() {
        return this.satPerVbyte;
    }

    public void setSatPerVbyte(String satPerVbyte) {
        this.satPerVbyte = satPerVbyte;
    }

    public LnrpcOpenChannelRequest nodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The pubkey of the node to open a channel with. When using REST, this field must be encoded as base64.")
    public byte[] getNodePubkey() {
        return this.nodePubkey;
    }

    public void setNodePubkey(byte[] nodePubkey) {
        this.nodePubkey = nodePubkey;
    }

    public LnrpcOpenChannelRequest nodePubkeyString(String nodePubkeyString) {
        this.nodePubkeyString = nodePubkeyString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hex encoded pubkey of the node to open a channel with. Deprecated now that the REST gateway supports base64 encoding of bytes fields.")
    public String getNodePubkeyString() {
        return this.nodePubkeyString;
    }

    public void setNodePubkeyString(String nodePubkeyString) {
        this.nodePubkeyString = nodePubkeyString;
    }

    public LnrpcOpenChannelRequest localFundingAmount(String localFundingAmount) {
        this.localFundingAmount = localFundingAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getLocalFundingAmount() {
        return this.localFundingAmount;
    }

    public void setLocalFundingAmount(String localFundingAmount) {
        this.localFundingAmount = localFundingAmount;
    }

    public LnrpcOpenChannelRequest pushSat(String pushSat) {
        this.pushSat = pushSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPushSat() {
        return this.pushSat;
    }

    public void setPushSat(String pushSat) {
        this.pushSat = pushSat;
    }

    public LnrpcOpenChannelRequest targetConf(Integer targetConf) {
        this.targetConf = targetConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The target number of blocks that the funding transaction should be confirmed by.")
    public Integer getTargetConf() {
        return this.targetConf;
    }

    public void setTargetConf(Integer targetConf) {
        this.targetConf = targetConf;
    }

    public LnrpcOpenChannelRequest satPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use sat_per_vbyte. A manual fee rate set in sat/vbyte that should be used when crafting the funding transaction.")
    public String getSatPerByte() {
        return this.satPerByte;
    }

    public void setSatPerByte(String satPerByte) {
        this.satPerByte = satPerByte;
    }

    public LnrpcOpenChannelRequest _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this channel should be private, not announced to the greater network.")
    public Boolean getPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public LnrpcOpenChannelRequest minHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum value in millisatoshi we will require for incoming HTLCs on the channel.")
    public String getMinHtlcMsat() {
        return this.minHtlcMsat;
    }

    public void setMinHtlcMsat(String minHtlcMsat) {
        this.minHtlcMsat = minHtlcMsat;
    }

    public LnrpcOpenChannelRequest remoteCsvDelay(Long remoteCsvDelay) {
        this.remoteCsvDelay = remoteCsvDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The delay we require on the remote's commitment transaction. If this is not set, it will be scaled automatically with the channel size.")
    public Long getRemoteCsvDelay() {
        return this.remoteCsvDelay;
    }

    public void setRemoteCsvDelay(Long remoteCsvDelay) {
        this.remoteCsvDelay = remoteCsvDelay;
    }

    public LnrpcOpenChannelRequest minConfs(Integer minConfs) {
        this.minConfs = minConfs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The minimum number of confirmations each one of your outputs used for the funding transaction must satisfy.")
    public Integer getMinConfs() {
        return this.minConfs;
    }

    public void setMinConfs(Integer minConfs) {
        this.minConfs = minConfs;
    }

    public LnrpcOpenChannelRequest spendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether unconfirmed outputs should be used as inputs for the funding transaction.")
    public Boolean getSpendUnconfirmed() {
        return this.spendUnconfirmed;
    }

    public void setSpendUnconfirmed(Boolean spendUnconfirmed) {
        this.spendUnconfirmed = spendUnconfirmed;
    }

    public LnrpcOpenChannelRequest closeAddress(String closeAddress) {
        this.closeAddress = closeAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Close address is an optional address which specifies the address to which funds should be paid out to upon cooperative close. This field may only be set if the peer supports the option upfront feature bit (call listpeers to check). The remote peer will only accept cooperative closes to this address if it is set.  Note: If this value is set on channel creation, you will *not* be able to cooperatively close out to a different address.")
    public String getCloseAddress() {
        return this.closeAddress;
    }

    public void setCloseAddress(String closeAddress) {
        this.closeAddress = closeAddress;
    }

    public LnrpcOpenChannelRequest fundingShim(LnrpcFundingShim fundingShim) {
        this.fundingShim = fundingShim;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcFundingShim getFundingShim() {
        return this.fundingShim;
    }

    public void setFundingShim(LnrpcFundingShim fundingShim) {
        this.fundingShim = fundingShim;
    }

    public LnrpcOpenChannelRequest remoteMaxValueInFlightMsat(String remoteMaxValueInFlightMsat) {
        this.remoteMaxValueInFlightMsat = remoteMaxValueInFlightMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum amount of coins in millisatoshi that can be pending within the channel. It only applies to the remote party.")
    public String getRemoteMaxValueInFlightMsat() {
        return this.remoteMaxValueInFlightMsat;
    }

    public void setRemoteMaxValueInFlightMsat(String remoteMaxValueInFlightMsat) {
        this.remoteMaxValueInFlightMsat = remoteMaxValueInFlightMsat;
    }

    public LnrpcOpenChannelRequest remoteMaxHtlcs(Long remoteMaxHtlcs) {
        this.remoteMaxHtlcs = remoteMaxHtlcs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of concurrent HTLCs we will allow the remote party to add to the commitment transaction.")
    public Long getRemoteMaxHtlcs() {
        return this.remoteMaxHtlcs;
    }

    public void setRemoteMaxHtlcs(Long remoteMaxHtlcs) {
        this.remoteMaxHtlcs = remoteMaxHtlcs;
    }

    public LnrpcOpenChannelRequest maxLocalCsv(Long maxLocalCsv) {
        this.maxLocalCsv = maxLocalCsv;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max local csv is the maximum csv delay we will allow for our own commitment transaction.")
    public Long getMaxLocalCsv() {
        return this.maxLocalCsv;
    }

    public void setMaxLocalCsv(Long maxLocalCsv) {
        this.maxLocalCsv = maxLocalCsv;
    }

    public LnrpcOpenChannelRequest commitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcCommitmentType getCommitmentType() {
        return this.commitmentType;
    }

    public void setCommitmentType(LnrpcCommitmentType commitmentType) {
        this.commitmentType = commitmentType;
    }

    public LnrpcOpenChannelRequest zeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is true, then a zero-conf channel open will be attempted.")
    public Boolean getZeroConf() {
        return this.zeroConf;
    }

    public void setZeroConf(Boolean zeroConf) {
        this.zeroConf = zeroConf;
    }

    public LnrpcOpenChannelRequest scidAlias(Boolean scidAlias) {
        this.scidAlias = scidAlias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is true, then an option-scid-alias channel-type open will be attempted.")
    public Boolean getScidAlias() {
        return this.scidAlias;
    }

    public void setScidAlias(Boolean scidAlias) {
        this.scidAlias = scidAlias;
    }

    public LnrpcOpenChannelRequest baseFee(String baseFee) {
        this.baseFee = baseFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The base fee charged regardless of the number of milli-satoshis sent.")
    public String getBaseFee() {
        return this.baseFee;
    }

    public void setBaseFee(String baseFee) {
        this.baseFee = baseFee;
    }

    public LnrpcOpenChannelRequest feeRate(String feeRate) {
        this.feeRate = feeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee rate in ppm (parts per million) that will be charged in proportion of the value of each forwarded HTLC.")
    public String getFeeRate() {
        return this.feeRate;
    }

    public void setFeeRate(String feeRate) {
        this.feeRate = feeRate;
    }

    public LnrpcOpenChannelRequest useBaseFee(Boolean useBaseFee) {
        this.useBaseFee = useBaseFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If use_base_fee is true the open channel announcement will update the channel base fee with the value specified in base_fee. In the case of a base_fee of 0 use_base_fee is needed downstream to distinguish whether to use the default base fee value specified in the config or 0.")
    public Boolean getUseBaseFee() {
        return this.useBaseFee;
    }

    public void setUseBaseFee(Boolean useBaseFee) {
        this.useBaseFee = useBaseFee;
    }

    public LnrpcOpenChannelRequest useFeeRate(Boolean useFeeRate) {
        this.useFeeRate = useFeeRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If use_fee_rate is true the open channel announcement will update the channel fee rate with the value specified in fee_rate. In the case of a fee_rate of 0 use_fee_rate is needed downstream to distinguish whether to use the default fee rate value specified in the config or 0.")
    public Boolean getUseFeeRate() {
        return this.useFeeRate;
    }

    public void setUseFeeRate(Boolean useFeeRate) {
        this.useFeeRate = useFeeRate;
    }

    public LnrpcOpenChannelRequest remoteChanReserveSat(String remoteChanReserveSat) {
        this.remoteChanReserveSat = remoteChanReserveSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of satoshis we require the remote peer to reserve. This value, if specified, must be above the dust limit and below 20% of the channel capacity.")
    public String getRemoteChanReserveSat() {
        return this.remoteChanReserveSat;
    }

    public void setRemoteChanReserveSat(String remoteChanReserveSat) {
        this.remoteChanReserveSat = remoteChanReserveSat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcOpenChannelRequest lnrpcOpenChannelRequest = (LnrpcOpenChannelRequest)o;
        return Objects.equals(this.satPerVbyte, lnrpcOpenChannelRequest.satPerVbyte) && Arrays.equals(this.nodePubkey, lnrpcOpenChannelRequest.nodePubkey) && Objects.equals(this.nodePubkeyString, lnrpcOpenChannelRequest.nodePubkeyString) && Objects.equals(this.localFundingAmount, lnrpcOpenChannelRequest.localFundingAmount) && Objects.equals(this.pushSat, lnrpcOpenChannelRequest.pushSat) && Objects.equals(this.targetConf, lnrpcOpenChannelRequest.targetConf) && Objects.equals(this.satPerByte, lnrpcOpenChannelRequest.satPerByte) && Objects.equals(this._private, lnrpcOpenChannelRequest._private) && Objects.equals(this.minHtlcMsat, lnrpcOpenChannelRequest.minHtlcMsat) && Objects.equals(this.remoteCsvDelay, lnrpcOpenChannelRequest.remoteCsvDelay) && Objects.equals(this.minConfs, lnrpcOpenChannelRequest.minConfs) && Objects.equals(this.spendUnconfirmed, lnrpcOpenChannelRequest.spendUnconfirmed) && Objects.equals(this.closeAddress, lnrpcOpenChannelRequest.closeAddress) && Objects.equals(this.fundingShim, lnrpcOpenChannelRequest.fundingShim) && Objects.equals(this.remoteMaxValueInFlightMsat, lnrpcOpenChannelRequest.remoteMaxValueInFlightMsat) && Objects.equals(this.remoteMaxHtlcs, lnrpcOpenChannelRequest.remoteMaxHtlcs) && Objects.equals(this.maxLocalCsv, lnrpcOpenChannelRequest.maxLocalCsv) && Objects.equals((Object)this.commitmentType, (Object)lnrpcOpenChannelRequest.commitmentType) && Objects.equals(this.zeroConf, lnrpcOpenChannelRequest.zeroConf) && Objects.equals(this.scidAlias, lnrpcOpenChannelRequest.scidAlias) && Objects.equals(this.baseFee, lnrpcOpenChannelRequest.baseFee) && Objects.equals(this.feeRate, lnrpcOpenChannelRequest.feeRate) && Objects.equals(this.useBaseFee, lnrpcOpenChannelRequest.useBaseFee) && Objects.equals(this.useFeeRate, lnrpcOpenChannelRequest.useFeeRate) && Objects.equals(this.remoteChanReserveSat, lnrpcOpenChannelRequest.remoteChanReserveSat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.satPerVbyte, Arrays.hashCode(this.nodePubkey), this.nodePubkeyString, this.localFundingAmount, this.pushSat, this.targetConf, this.satPerByte, this._private, this.minHtlcMsat, this.remoteCsvDelay, this.minConfs, this.spendUnconfirmed, this.closeAddress, this.fundingShim, this.remoteMaxValueInFlightMsat, this.remoteMaxHtlcs, this.maxLocalCsv, this.commitmentType, this.zeroConf, this.scidAlias, this.baseFee, this.feeRate, this.useBaseFee, this.useFeeRate, this.remoteChanReserveSat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcOpenChannelRequest {\n");
        sb.append("    satPerVbyte: ").append(this.toIndentedString(this.satPerVbyte)).append("\n");
        sb.append("    nodePubkey: ").append(this.toIndentedString(this.nodePubkey)).append("\n");
        sb.append("    nodePubkeyString: ").append(this.toIndentedString(this.nodePubkeyString)).append("\n");
        sb.append("    localFundingAmount: ").append(this.toIndentedString(this.localFundingAmount)).append("\n");
        sb.append("    pushSat: ").append(this.toIndentedString(this.pushSat)).append("\n");
        sb.append("    targetConf: ").append(this.toIndentedString(this.targetConf)).append("\n");
        sb.append("    satPerByte: ").append(this.toIndentedString(this.satPerByte)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    minHtlcMsat: ").append(this.toIndentedString(this.minHtlcMsat)).append("\n");
        sb.append("    remoteCsvDelay: ").append(this.toIndentedString(this.remoteCsvDelay)).append("\n");
        sb.append("    minConfs: ").append(this.toIndentedString(this.minConfs)).append("\n");
        sb.append("    spendUnconfirmed: ").append(this.toIndentedString(this.spendUnconfirmed)).append("\n");
        sb.append("    closeAddress: ").append(this.toIndentedString(this.closeAddress)).append("\n");
        sb.append("    fundingShim: ").append(this.toIndentedString(this.fundingShim)).append("\n");
        sb.append("    remoteMaxValueInFlightMsat: ").append(this.toIndentedString(this.remoteMaxValueInFlightMsat)).append("\n");
        sb.append("    remoteMaxHtlcs: ").append(this.toIndentedString(this.remoteMaxHtlcs)).append("\n");
        sb.append("    maxLocalCsv: ").append(this.toIndentedString(this.maxLocalCsv)).append("\n");
        sb.append("    commitmentType: ").append(this.toIndentedString((Object)this.commitmentType)).append("\n");
        sb.append("    zeroConf: ").append(this.toIndentedString(this.zeroConf)).append("\n");
        sb.append("    scidAlias: ").append(this.toIndentedString(this.scidAlias)).append("\n");
        sb.append("    baseFee: ").append(this.toIndentedString(this.baseFee)).append("\n");
        sb.append("    feeRate: ").append(this.toIndentedString(this.feeRate)).append("\n");
        sb.append("    useBaseFee: ").append(this.toIndentedString(this.useBaseFee)).append("\n");
        sb.append("    useFeeRate: ").append(this.toIndentedString(this.useFeeRate)).append("\n");
        sb.append("    remoteChanReserveSat: ").append(this.toIndentedString(this.remoteChanReserveSat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

