/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcFeature;
import net.osslabz.lnd.dto.LnrpcNodeAddress;

public class LnrpcNodeUpdate {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<String> addresses = null;
    public static final String SERIALIZED_NAME_IDENTITY_KEY = "identity_key";
    @SerializedName(value="identity_key")
    private String identityKey;
    public static final String SERIALIZED_NAME_GLOBAL_FEATURES = "global_features";
    @SerializedName(value="global_features")
    private byte[] globalFeatures;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color;
    public static final String SERIALIZED_NAME_NODE_ADDRESSES = "node_addresses";
    @SerializedName(value="node_addresses")
    private List<LnrpcNodeAddress> nodeAddresses = null;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, LnrpcFeature> features = null;

    public LnrpcNodeUpdate addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public LnrpcNodeUpdate addAddressesItem(String addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use node_addresses.")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public LnrpcNodeUpdate identityKey(String identityKey) {
        this.identityKey = identityKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getIdentityKey() {
        return this.identityKey;
    }

    public void setIdentityKey(String identityKey) {
        this.identityKey = identityKey;
    }

    public LnrpcNodeUpdate globalFeatures(byte[] globalFeatures) {
        this.globalFeatures = globalFeatures;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use features.")
    public byte[] getGlobalFeatures() {
        return this.globalFeatures;
    }

    public void setGlobalFeatures(byte[] globalFeatures) {
        this.globalFeatures = globalFeatures;
    }

    public LnrpcNodeUpdate alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public LnrpcNodeUpdate color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public LnrpcNodeUpdate nodeAddresses(List<LnrpcNodeAddress> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
        return this;
    }

    public LnrpcNodeUpdate addNodeAddressesItem(LnrpcNodeAddress nodeAddressesItem) {
        if (this.nodeAddresses == null) {
            this.nodeAddresses = new ArrayList<LnrpcNodeAddress>();
        }
        this.nodeAddresses.add(nodeAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcNodeAddress> getNodeAddresses() {
        return this.nodeAddresses;
    }

    public void setNodeAddresses(List<LnrpcNodeAddress> nodeAddresses) {
        this.nodeAddresses = nodeAddresses;
    }

    public LnrpcNodeUpdate features(Map<String, LnrpcFeature> features) {
        this.features = features;
        return this;
    }

    public LnrpcNodeUpdate putFeaturesItem(String key, LnrpcFeature featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, LnrpcFeature>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Features that the node has advertised in the init message, node announcements and invoices.")
    public Map<String, LnrpcFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, LnrpcFeature> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcNodeUpdate lnrpcNodeUpdate = (LnrpcNodeUpdate)o;
        return Objects.equals(this.addresses, lnrpcNodeUpdate.addresses) && Objects.equals(this.identityKey, lnrpcNodeUpdate.identityKey) && Arrays.equals(this.globalFeatures, lnrpcNodeUpdate.globalFeatures) && Objects.equals(this.alias, lnrpcNodeUpdate.alias) && Objects.equals(this.color, lnrpcNodeUpdate.color) && Objects.equals(this.nodeAddresses, lnrpcNodeUpdate.nodeAddresses) && Objects.equals(this.features, lnrpcNodeUpdate.features);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.identityKey, Arrays.hashCode(this.globalFeatures), this.alias, this.color, this.nodeAddresses, this.features);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcNodeUpdate {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    identityKey: ").append(this.toIndentedString(this.identityKey)).append("\n");
        sb.append("    globalFeatures: ").append(this.toIndentedString(this.globalFeatures)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    nodeAddresses: ").append(this.toIndentedString(this.nodeAddresses)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

