/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelEdge;
import net.osslabz.lnd.dto.LnrpcLightningNode;

public class LnrpcNodeInfo {
    public static final String SERIALIZED_NAME_NODE = "node";
    @SerializedName(value="node")
    private LnrpcLightningNode node;
    public static final String SERIALIZED_NAME_NUM_CHANNELS = "num_channels";
    @SerializedName(value="num_channels")
    private Long numChannels;
    public static final String SERIALIZED_NAME_TOTAL_CAPACITY = "total_capacity";
    @SerializedName(value="total_capacity")
    private String totalCapacity;
    public static final String SERIALIZED_NAME_CHANNELS = "channels";
    @SerializedName(value="channels")
    private List<LnrpcChannelEdge> channels = null;

    public LnrpcNodeInfo node(LnrpcLightningNode node) {
        this.node = node;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcLightningNode getNode() {
        return this.node;
    }

    public void setNode(LnrpcLightningNode node) {
        this.node = node;
    }

    public LnrpcNodeInfo numChannels(Long numChannels) {
        this.numChannels = numChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of channels for the node.")
    public Long getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(Long numChannels) {
        this.numChannels = numChannels;
    }

    public LnrpcNodeInfo totalCapacity(String totalCapacity) {
        this.totalCapacity = totalCapacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sum of all channels capacity for the node, denominated in satoshis.")
    public String getTotalCapacity() {
        return this.totalCapacity;
    }

    public void setTotalCapacity(String totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public LnrpcNodeInfo channels(List<LnrpcChannelEdge> channels) {
        this.channels = channels;
        return this;
    }

    public LnrpcNodeInfo addChannelsItem(LnrpcChannelEdge channelsItem) {
        if (this.channels == null) {
            this.channels = new ArrayList<LnrpcChannelEdge>();
        }
        this.channels.add(channelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of all public channels for the node.")
    public List<LnrpcChannelEdge> getChannels() {
        return this.channels;
    }

    public void setChannels(List<LnrpcChannelEdge> channels) {
        this.channels = channels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcNodeInfo lnrpcNodeInfo = (LnrpcNodeInfo)o;
        return Objects.equals(this.node, lnrpcNodeInfo.node) && Objects.equals(this.numChannels, lnrpcNodeInfo.numChannels) && Objects.equals(this.totalCapacity, lnrpcNodeInfo.totalCapacity) && Objects.equals(this.channels, lnrpcNodeInfo.channels);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.numChannels, this.totalCapacity, this.channels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcNodeInfo {\n");
        sb.append("    node: ").append(this.toIndentedString(this.node)).append("\n");
        sb.append("    numChannels: ").append(this.toIndentedString(this.numChannels)).append("\n");
        sb.append("    totalCapacity: ").append(this.toIndentedString(this.totalCapacity)).append("\n");
        sb.append("    channels: ").append(this.toIndentedString(this.channels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

