/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcChannelPoint;

public class LnrpcMultiChanBackup {
    public static final String SERIALIZED_NAME_CHAN_POINTS = "chan_points";
    @SerializedName(value="chan_points")
    private List<LnrpcChannelPoint> chanPoints = null;
    public static final String SERIALIZED_NAME_MULTI_CHAN_BACKUP = "multi_chan_backup";
    @SerializedName(value="multi_chan_backup")
    private byte[] multiChanBackup;

    public LnrpcMultiChanBackup chanPoints(List<LnrpcChannelPoint> chanPoints) {
        this.chanPoints = chanPoints;
        return this;
    }

    public LnrpcMultiChanBackup addChanPointsItem(LnrpcChannelPoint chanPointsItem) {
        if (this.chanPoints == null) {
            this.chanPoints = new ArrayList<LnrpcChannelPoint>();
        }
        this.chanPoints.add(chanPointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the set of all channels that are included in this multi-channel backup.")
    public List<LnrpcChannelPoint> getChanPoints() {
        return this.chanPoints;
    }

    public void setChanPoints(List<LnrpcChannelPoint> chanPoints) {
        this.chanPoints = chanPoints;
    }

    public LnrpcMultiChanBackup multiChanBackup(byte[] multiChanBackup) {
        this.multiChanBackup = multiChanBackup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A single encrypted blob containing all the static channel backups of the channel listed above. This can be stored as a single file or blob, and safely be replaced with any prior/future versions. When using REST, this field must be encoded as base64.")
    public byte[] getMultiChanBackup() {
        return this.multiChanBackup;
    }

    public void setMultiChanBackup(byte[] multiChanBackup) {
        this.multiChanBackup = multiChanBackup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcMultiChanBackup lnrpcMultiChanBackup = (LnrpcMultiChanBackup)o;
        return Objects.equals(this.chanPoints, lnrpcMultiChanBackup.chanPoints) && Arrays.equals(this.multiChanBackup, lnrpcMultiChanBackup.multiChanBackup);
    }

    public int hashCode() {
        return Objects.hash(this.chanPoints, Arrays.hashCode(this.multiChanBackup));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcMultiChanBackup {\n");
        sb.append("    chanPoints: ").append(this.toIndentedString(this.chanPoints)).append("\n");
        sb.append("    multiChanBackup: ").append(this.toIndentedString(this.multiChanBackup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

