/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LnrpcMiddlewareRegistration {
    public static final String SERIALIZED_NAME_MIDDLEWARE_NAME = "middleware_name";
    @SerializedName(value="middleware_name")
    private String middlewareName;
    public static final String SERIALIZED_NAME_CUSTOM_MACAROON_CAVEAT_NAME = "custom_macaroon_caveat_name";
    @SerializedName(value="custom_macaroon_caveat_name")
    private String customMacaroonCaveatName;
    public static final String SERIALIZED_NAME_READ_ONLY_MODE = "read_only_mode";
    @SerializedName(value="read_only_mode")
    private Boolean readOnlyMode;

    public LnrpcMiddlewareRegistration middlewareName(String middlewareName) {
        this.middlewareName = middlewareName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the middleware to register. The name should be as informative as possible and is logged on registration.")
    public String getMiddlewareName() {
        return this.middlewareName;
    }

    public void setMiddlewareName(String middlewareName) {
        this.middlewareName = middlewareName;
    }

    public LnrpcMiddlewareRegistration customMacaroonCaveatName(String customMacaroonCaveatName) {
        this.customMacaroonCaveatName = customMacaroonCaveatName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the custom macaroon caveat that this middleware is responsible for. Only requests/responses that contain a macaroon with the registered custom caveat are forwarded for interception to the middleware. The exception being the read-only mode: All requests/responses are forwarded to a middleware that requests read-only access but such a middleware won't be allowed to _alter_ responses. As a security measure, _no_ middleware can change responses to requests made with _unencumbered_ macaroons! NOTE: Cannot be used at the same time as read_only_mode.")
    public String getCustomMacaroonCaveatName() {
        return this.customMacaroonCaveatName;
    }

    public void setCustomMacaroonCaveatName(String customMacaroonCaveatName) {
        this.customMacaroonCaveatName = customMacaroonCaveatName;
    }

    public LnrpcMiddlewareRegistration readOnlyMode(Boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Instead of defining a custom macaroon caveat name a middleware can register itself for read-only access only. In that mode all requests/responses are forwarded to the middleware but the middleware isn't allowed to alter any of the responses. NOTE: Cannot be used at the same time as custom_macaroon_caveat_name.")
    public Boolean getReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void setReadOnlyMode(Boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcMiddlewareRegistration lnrpcMiddlewareRegistration = (LnrpcMiddlewareRegistration)o;
        return Objects.equals(this.middlewareName, lnrpcMiddlewareRegistration.middlewareName) && Objects.equals(this.customMacaroonCaveatName, lnrpcMiddlewareRegistration.customMacaroonCaveatName) && Objects.equals(this.readOnlyMode, lnrpcMiddlewareRegistration.readOnlyMode);
    }

    public int hashCode() {
        return Objects.hash(this.middlewareName, this.customMacaroonCaveatName, this.readOnlyMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcMiddlewareRegistration {\n");
        sb.append("    middlewareName: ").append(this.toIndentedString(this.middlewareName)).append("\n");
        sb.append("    customMacaroonCaveatName: ").append(this.toIndentedString(this.customMacaroonCaveatName)).append("\n");
        sb.append("    readOnlyMode: ").append(this.toIndentedString(this.readOnlyMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

