/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class LnrpcMPPRecord {
    public static final String SERIALIZED_NAME_PAYMENT_ADDR = "payment_addr";
    @SerializedName(value="payment_addr")
    private byte[] paymentAddr;
    public static final String SERIALIZED_NAME_TOTAL_AMT_MSAT = "total_amt_msat";
    @SerializedName(value="total_amt_msat")
    private String totalAmtMsat;

    public LnrpcMPPRecord paymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, random identifier used to authenticate the sender as the intended payer of a multi-path payment. The payment_addr must be the same for all subpayments, and match the payment_addr provided in the receiver's invoice. The same payment_addr must be used on all subpayments.")
    public byte[] getPaymentAddr() {
        return this.paymentAddr;
    }

    public void setPaymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
    }

    public LnrpcMPPRecord totalAmtMsat(String totalAmtMsat) {
        this.totalAmtMsat = totalAmtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount in milli-satoshis being sent as part of a larger multi-path payment. The caller is responsible for ensuring subpayments to the same node and payment_hash sum exactly to total_amt_msat. The same total_amt_msat must be used on all subpayments.")
    public String getTotalAmtMsat() {
        return this.totalAmtMsat;
    }

    public void setTotalAmtMsat(String totalAmtMsat) {
        this.totalAmtMsat = totalAmtMsat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcMPPRecord lnrpcMPPRecord = (LnrpcMPPRecord)o;
        return Arrays.equals(this.paymentAddr, lnrpcMPPRecord.paymentAddr) && Objects.equals(this.totalAmtMsat, lnrpcMPPRecord.totalAmtMsat);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.paymentAddr), this.totalAmtMsat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcMPPRecord {\n");
        sb.append("    paymentAddr: ").append(this.toIndentedString(this.paymentAddr)).append("\n");
        sb.append("    totalAmtMsat: ").append(this.toIndentedString(this.totalAmtMsat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

