/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcPayment;

public class LnrpcListPaymentsResponse {
    public static final String SERIALIZED_NAME_PAYMENTS = "payments";
    @SerializedName(value="payments")
    private List<LnrpcPayment> payments = null;
    public static final String SERIALIZED_NAME_FIRST_INDEX_OFFSET = "first_index_offset";
    @SerializedName(value="first_index_offset")
    private String firstIndexOffset;
    public static final String SERIALIZED_NAME_LAST_INDEX_OFFSET = "last_index_offset";
    @SerializedName(value="last_index_offset")
    private String lastIndexOffset;
    public static final String SERIALIZED_NAME_TOTAL_NUM_PAYMENTS = "total_num_payments";
    @SerializedName(value="total_num_payments")
    private String totalNumPayments;

    public LnrpcListPaymentsResponse payments(List<LnrpcPayment> payments) {
        this.payments = payments;
        return this;
    }

    public LnrpcListPaymentsResponse addPaymentsItem(LnrpcPayment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<LnrpcPayment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcPayment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<LnrpcPayment> payments) {
        this.payments = payments;
    }

    public LnrpcListPaymentsResponse firstIndexOffset(String firstIndexOffset) {
        this.firstIndexOffset = firstIndexOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The index of the first item in the set of returned payments. This can be used as the index_offset to continue seeking backwards in the next request.")
    public String getFirstIndexOffset() {
        return this.firstIndexOffset;
    }

    public void setFirstIndexOffset(String firstIndexOffset) {
        this.firstIndexOffset = firstIndexOffset;
    }

    public LnrpcListPaymentsResponse lastIndexOffset(String lastIndexOffset) {
        this.lastIndexOffset = lastIndexOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The index of the last item in the set of returned payments. This can be used as the index_offset to continue seeking forwards in the next request.")
    public String getLastIndexOffset() {
        return this.lastIndexOffset;
    }

    public void setLastIndexOffset(String lastIndexOffset) {
        this.lastIndexOffset = lastIndexOffset;
    }

    public LnrpcListPaymentsResponse totalNumPayments(String totalNumPayments) {
        this.totalNumPayments = totalNumPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Will only be set if count_total_payments in the request was set. Represents the total number of payments (complete and incomplete, independent of the number of payments requested in the query) currently present in the payments database.")
    public String getTotalNumPayments() {
        return this.totalNumPayments;
    }

    public void setTotalNumPayments(String totalNumPayments) {
        this.totalNumPayments = totalNumPayments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcListPaymentsResponse lnrpcListPaymentsResponse = (LnrpcListPaymentsResponse)o;
        return Objects.equals(this.payments, lnrpcListPaymentsResponse.payments) && Objects.equals(this.firstIndexOffset, lnrpcListPaymentsResponse.firstIndexOffset) && Objects.equals(this.lastIndexOffset, lnrpcListPaymentsResponse.lastIndexOffset) && Objects.equals(this.totalNumPayments, lnrpcListPaymentsResponse.totalNumPayments);
    }

    public int hashCode() {
        return Objects.hash(this.payments, this.firstIndexOffset, this.lastIndexOffset, this.totalNumPayments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcListPaymentsResponse {\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    firstIndexOffset: ").append(this.toIndentedString(this.firstIndexOffset)).append("\n");
        sb.append("    lastIndexOffset: ").append(this.toIndentedString(this.lastIndexOffset)).append("\n");
        sb.append("    totalNumPayments: ").append(this.toIndentedString(this.totalNumPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

