/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcFeature;
import net.osslabz.lnd.dto.LnrpcNodeAddress;

@ApiModel(description="An individual vertex/node within the channel graph. A node is connected to other nodes by one or more channel edges emanating from it. As the graph is directed, a node will also have an incoming edge attached to it for each outgoing edge.")
public class LnrpcLightningNode {
    public static final String SERIALIZED_NAME_LAST_UPDATE = "last_update";
    @SerializedName(value="last_update")
    private Long lastUpdate;
    public static final String SERIALIZED_NAME_PUB_KEY = "pub_key";
    @SerializedName(value="pub_key")
    private String pubKey;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<LnrpcNodeAddress> addresses = null;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    private String color;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, LnrpcFeature> features = null;
    public static final String SERIALIZED_NAME_CUSTOM_RECORDS = "custom_records";
    @SerializedName(value="custom_records")
    private Map<String, byte[]> customRecords = null;

    public LnrpcLightningNode lastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public LnrpcLightningNode pubKey(String pubKey) {
        this.pubKey = pubKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public LnrpcLightningNode alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public LnrpcLightningNode addresses(List<LnrpcNodeAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public LnrpcLightningNode addAddressesItem(LnrpcNodeAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<LnrpcNodeAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<LnrpcNodeAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<LnrpcNodeAddress> addresses) {
        this.addresses = addresses;
    }

    public LnrpcLightningNode color(String color) {
        this.color = color;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public LnrpcLightningNode features(Map<String, LnrpcFeature> features) {
        this.features = features;
        return this;
    }

    public LnrpcLightningNode putFeaturesItem(String key, LnrpcFeature featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, LnrpcFeature>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, LnrpcFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, LnrpcFeature> features) {
        this.features = features;
    }

    public LnrpcLightningNode customRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
        return this;
    }

    public LnrpcLightningNode putCustomRecordsItem(String key, byte[] customRecordsItem) {
        if (this.customRecords == null) {
            this.customRecords = new HashMap<String, byte[]>();
        }
        this.customRecords.put(key, customRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom node announcement tlv records.")
    public Map<String, byte[]> getCustomRecords() {
        return this.customRecords;
    }

    public void setCustomRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcLightningNode lnrpcLightningNode = (LnrpcLightningNode)o;
        return Objects.equals(this.lastUpdate, lnrpcLightningNode.lastUpdate) && Objects.equals(this.pubKey, lnrpcLightningNode.pubKey) && Objects.equals(this.alias, lnrpcLightningNode.alias) && Objects.equals(this.addresses, lnrpcLightningNode.addresses) && Objects.equals(this.color, lnrpcLightningNode.color) && Objects.equals(this.features, lnrpcLightningNode.features) && Objects.equals(this.customRecords, lnrpcLightningNode.customRecords);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdate, this.pubKey, this.alias, this.addresses, this.color, this.features, this.customRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcLightningNode {\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    pubKey: ").append(this.toIndentedString(this.pubKey)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    customRecords: ").append(this.toIndentedString(this.customRecords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

