/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.LnrpcAMP;
import net.osslabz.lnd.dto.LnrpcInvoiceHTLCState;

public class LnrpcInvoiceHTLC {
    public static final String SERIALIZED_NAME_CHAN_ID = "chan_id";
    @SerializedName(value="chan_id")
    private String chanId;
    public static final String SERIALIZED_NAME_HTLC_INDEX = "htlc_index";
    @SerializedName(value="htlc_index")
    private String htlcIndex;
    public static final String SERIALIZED_NAME_AMT_MSAT = "amt_msat";
    @SerializedName(value="amt_msat")
    private String amtMsat;
    public static final String SERIALIZED_NAME_ACCEPT_HEIGHT = "accept_height";
    @SerializedName(value="accept_height")
    private Integer acceptHeight;
    public static final String SERIALIZED_NAME_ACCEPT_TIME = "accept_time";
    @SerializedName(value="accept_time")
    private String acceptTime;
    public static final String SERIALIZED_NAME_RESOLVE_TIME = "resolve_time";
    @SerializedName(value="resolve_time")
    private String resolveTime;
    public static final String SERIALIZED_NAME_EXPIRY_HEIGHT = "expiry_height";
    @SerializedName(value="expiry_height")
    private Integer expiryHeight;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private LnrpcInvoiceHTLCState state = LnrpcInvoiceHTLCState.ACCEPTED;
    public static final String SERIALIZED_NAME_CUSTOM_RECORDS = "custom_records";
    @SerializedName(value="custom_records")
    private Map<String, byte[]> customRecords = null;
    public static final String SERIALIZED_NAME_MPP_TOTAL_AMT_MSAT = "mpp_total_amt_msat";
    @SerializedName(value="mpp_total_amt_msat")
    private String mppTotalAmtMsat;
    public static final String SERIALIZED_NAME_AMP = "amp";
    @SerializedName(value="amp")
    private LnrpcAMP amp;

    public LnrpcInvoiceHTLC chanId(String chanId) {
        this.chanId = chanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Short channel id over which the htlc was received.")
    public String getChanId() {
        return this.chanId;
    }

    public void setChanId(String chanId) {
        this.chanId = chanId;
    }

    public LnrpcInvoiceHTLC htlcIndex(String htlcIndex) {
        this.htlcIndex = htlcIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Index identifying the htlc on the channel.")
    public String getHtlcIndex() {
        return this.htlcIndex;
    }

    public void setHtlcIndex(String htlcIndex) {
        this.htlcIndex = htlcIndex;
    }

    public LnrpcInvoiceHTLC amtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the htlc in msat.")
    public String getAmtMsat() {
        return this.amtMsat;
    }

    public void setAmtMsat(String amtMsat) {
        this.amtMsat = amtMsat;
    }

    public LnrpcInvoiceHTLC acceptHeight(Integer acceptHeight) {
        this.acceptHeight = acceptHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Block height at which this htlc was accepted.")
    public Integer getAcceptHeight() {
        return this.acceptHeight;
    }

    public void setAcceptHeight(Integer acceptHeight) {
        this.acceptHeight = acceptHeight;
    }

    public LnrpcInvoiceHTLC acceptTime(String acceptTime) {
        this.acceptTime = acceptTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time at which this htlc was accepted.")
    public String getAcceptTime() {
        return this.acceptTime;
    }

    public void setAcceptTime(String acceptTime) {
        this.acceptTime = acceptTime;
    }

    public LnrpcInvoiceHTLC resolveTime(String resolveTime) {
        this.resolveTime = resolveTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time at which this htlc was settled or canceled.")
    public String getResolveTime() {
        return this.resolveTime;
    }

    public void setResolveTime(String resolveTime) {
        this.resolveTime = resolveTime;
    }

    public LnrpcInvoiceHTLC expiryHeight(Integer expiryHeight) {
        this.expiryHeight = expiryHeight;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Block height at which this htlc expires.")
    public Integer getExpiryHeight() {
        return this.expiryHeight;
    }

    public void setExpiryHeight(Integer expiryHeight) {
        this.expiryHeight = expiryHeight;
    }

    public LnrpcInvoiceHTLC state(LnrpcInvoiceHTLCState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcInvoiceHTLCState getState() {
        return this.state;
    }

    public void setState(LnrpcInvoiceHTLCState state) {
        this.state = state;
    }

    public LnrpcInvoiceHTLC customRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
        return this;
    }

    public LnrpcInvoiceHTLC putCustomRecordsItem(String key, byte[] customRecordsItem) {
        if (this.customRecords == null) {
            this.customRecords = new HashMap<String, byte[]>();
        }
        this.customRecords.put(key, customRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom tlv records.")
    public Map<String, byte[]> getCustomRecords() {
        return this.customRecords;
    }

    public void setCustomRecords(Map<String, byte[]> customRecords) {
        this.customRecords = customRecords;
    }

    public LnrpcInvoiceHTLC mppTotalAmtMsat(String mppTotalAmtMsat) {
        this.mppTotalAmtMsat = mppTotalAmtMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of the mpp payment in msat.")
    public String getMppTotalAmtMsat() {
        return this.mppTotalAmtMsat;
    }

    public void setMppTotalAmtMsat(String mppTotalAmtMsat) {
        this.mppTotalAmtMsat = mppTotalAmtMsat;
    }

    public LnrpcInvoiceHTLC amp(LnrpcAMP amp) {
        this.amp = amp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LnrpcAMP getAmp() {
        return this.amp;
    }

    public void setAmp(LnrpcAMP amp) {
        this.amp = amp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcInvoiceHTLC lnrpcInvoiceHTLC = (LnrpcInvoiceHTLC)o;
        return Objects.equals(this.chanId, lnrpcInvoiceHTLC.chanId) && Objects.equals(this.htlcIndex, lnrpcInvoiceHTLC.htlcIndex) && Objects.equals(this.amtMsat, lnrpcInvoiceHTLC.amtMsat) && Objects.equals(this.acceptHeight, lnrpcInvoiceHTLC.acceptHeight) && Objects.equals(this.acceptTime, lnrpcInvoiceHTLC.acceptTime) && Objects.equals(this.resolveTime, lnrpcInvoiceHTLC.resolveTime) && Objects.equals(this.expiryHeight, lnrpcInvoiceHTLC.expiryHeight) && Objects.equals((Object)this.state, (Object)lnrpcInvoiceHTLC.state) && Objects.equals(this.customRecords, lnrpcInvoiceHTLC.customRecords) && Objects.equals(this.mppTotalAmtMsat, lnrpcInvoiceHTLC.mppTotalAmtMsat) && Objects.equals(this.amp, lnrpcInvoiceHTLC.amp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chanId, this.htlcIndex, this.amtMsat, this.acceptHeight, this.acceptTime, this.resolveTime, this.expiryHeight, this.state, this.customRecords, this.mppTotalAmtMsat, this.amp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcInvoiceHTLC {\n");
        sb.append("    chanId: ").append(this.toIndentedString(this.chanId)).append("\n");
        sb.append("    htlcIndex: ").append(this.toIndentedString(this.htlcIndex)).append("\n");
        sb.append("    amtMsat: ").append(this.toIndentedString(this.amtMsat)).append("\n");
        sb.append("    acceptHeight: ").append(this.toIndentedString(this.acceptHeight)).append("\n");
        sb.append("    acceptTime: ").append(this.toIndentedString(this.acceptTime)).append("\n");
        sb.append("    resolveTime: ").append(this.toIndentedString(this.resolveTime)).append("\n");
        sb.append("    expiryHeight: ").append(this.toIndentedString(this.expiryHeight)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    customRecords: ").append(this.toIndentedString(this.customRecords)).append("\n");
        sb.append("    mppTotalAmtMsat: ").append(this.toIndentedString(this.mppTotalAmtMsat)).append("\n");
        sb.append("    amp: ").append(this.toIndentedString(this.amp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

