/*
 * Decompiled with CFR 0.152.
 */
package net.osslabz.lnd.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.osslabz.lnd.dto.InvoiceInvoiceState;
import net.osslabz.lnd.dto.LnrpcAMPInvoiceState;
import net.osslabz.lnd.dto.LnrpcFeature;
import net.osslabz.lnd.dto.LnrpcInvoiceHTLC;
import net.osslabz.lnd.dto.LnrpcRouteHint;

public class LnrpcInvoice {
    public static final String SERIALIZED_NAME_MEMO = "memo";
    @SerializedName(value="memo")
    private String memo;
    public static final String SERIALIZED_NAME_R_PREIMAGE = "r_preimage";
    @SerializedName(value="r_preimage")
    private byte[] rPreimage;
    public static final String SERIALIZED_NAME_R_HASH = "r_hash";
    @SerializedName(value="r_hash")
    private byte[] rHash;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_VALUE_MSAT = "value_msat";
    @SerializedName(value="value_msat")
    private String valueMsat;
    public static final String SERIALIZED_NAME_SETTLED = "settled";
    @SerializedName(value="settled")
    private Boolean settled;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creation_date";
    @SerializedName(value="creation_date")
    private String creationDate;
    public static final String SERIALIZED_NAME_SETTLE_DATE = "settle_date";
    @SerializedName(value="settle_date")
    private String settleDate;
    public static final String SERIALIZED_NAME_PAYMENT_REQUEST = "payment_request";
    @SerializedName(value="payment_request")
    private String paymentRequest;
    public static final String SERIALIZED_NAME_DESCRIPTION_HASH = "description_hash";
    @SerializedName(value="description_hash")
    private byte[] descriptionHash;
    public static final String SERIALIZED_NAME_EXPIRY = "expiry";
    @SerializedName(value="expiry")
    private String expiry;
    public static final String SERIALIZED_NAME_FALLBACK_ADDR = "fallback_addr";
    @SerializedName(value="fallback_addr")
    private String fallbackAddr;
    public static final String SERIALIZED_NAME_CLTV_EXPIRY = "cltv_expiry";
    @SerializedName(value="cltv_expiry")
    private String cltvExpiry;
    public static final String SERIALIZED_NAME_ROUTE_HINTS = "route_hints";
    @SerializedName(value="route_hints")
    private List<LnrpcRouteHint> routeHints = null;
    public static final String SERIALIZED_NAME_PRIVATE = "private";
    @SerializedName(value="private")
    private Boolean _private;
    public static final String SERIALIZED_NAME_ADD_INDEX = "add_index";
    @SerializedName(value="add_index")
    private String addIndex;
    public static final String SERIALIZED_NAME_SETTLE_INDEX = "settle_index";
    @SerializedName(value="settle_index")
    private String settleIndex;
    public static final String SERIALIZED_NAME_AMT_PAID = "amt_paid";
    @SerializedName(value="amt_paid")
    private String amtPaid;
    public static final String SERIALIZED_NAME_AMT_PAID_SAT = "amt_paid_sat";
    @SerializedName(value="amt_paid_sat")
    private String amtPaidSat;
    public static final String SERIALIZED_NAME_AMT_PAID_MSAT = "amt_paid_msat";
    @SerializedName(value="amt_paid_msat")
    private String amtPaidMsat;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private InvoiceInvoiceState state = InvoiceInvoiceState.OPEN;
    public static final String SERIALIZED_NAME_HTLCS = "htlcs";
    @SerializedName(value="htlcs")
    private List<LnrpcInvoiceHTLC> htlcs = null;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private Map<String, LnrpcFeature> features = null;
    public static final String SERIALIZED_NAME_IS_KEYSEND = "is_keysend";
    @SerializedName(value="is_keysend")
    private Boolean isKeysend;
    public static final String SERIALIZED_NAME_PAYMENT_ADDR = "payment_addr";
    @SerializedName(value="payment_addr")
    private byte[] paymentAddr;
    public static final String SERIALIZED_NAME_IS_AMP = "is_amp";
    @SerializedName(value="is_amp")
    private Boolean isAmp;
    public static final String SERIALIZED_NAME_AMP_INVOICE_STATE = "amp_invoice_state";
    @SerializedName(value="amp_invoice_state")
    private Map<String, LnrpcAMPInvoiceState> ampInvoiceState = null;

    public LnrpcInvoice memo(String memo) {
        this.memo = memo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional memo to attach along with the invoice. Used for record keeping purposes for the invoice's creator, and will also be set in the description field of the encoded payment request if the description_hash field is not being used.")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public LnrpcInvoice rPreimage(byte[] rPreimage) {
        this.rPreimage = rPreimage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hex-encoded preimage (32 byte) which will allow settling an incoming HTLC payable to this preimage. When using REST, this field must be encoded as base64.")
    public byte[] getrPreimage() {
        return this.rPreimage;
    }

    public void setrPreimage(byte[] rPreimage) {
        this.rPreimage = rPreimage;
    }

    public LnrpcInvoice rHash(byte[] rHash) {
        this.rHash = rHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash of the preimage. When using REST, this field must be encoded as base64. Note: Output only, don't specify for creating an invoice.")
    public byte[] getrHash() {
        return this.rHash;
    }

    public void setrHash(byte[] rHash) {
        this.rHash = rHash;
    }

    public LnrpcInvoice value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fields value and value_msat are mutually exclusive.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public LnrpcInvoice valueMsat(String valueMsat) {
        this.valueMsat = valueMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fields value and value_msat are mutually exclusive.")
    public String getValueMsat() {
        return this.valueMsat;
    }

    public void setValueMsat(String valueMsat) {
        this.valueMsat = valueMsat;
    }

    public LnrpcInvoice settled(Boolean settled) {
        this.settled = settled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this invoice has been fulfilled.  The field is deprecated. Use the state field instead (compare to SETTLED).")
    public Boolean getSettled() {
        return this.settled;
    }

    public void setSettled(Boolean settled) {
        this.settled = settled;
    }

    public LnrpcInvoice creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this invoice was created. Measured in seconds since the unix epoch. Note: Output only, don't specify for creating an invoice.")
    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public LnrpcInvoice settleDate(String settleDate) {
        this.settleDate = settleDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When this invoice was settled. Measured in seconds since the unix epoch. Note: Output only, don't specify for creating an invoice.")
    public String getSettleDate() {
        return this.settleDate;
    }

    public void setSettleDate(String settleDate) {
        this.settleDate = settleDate;
    }

    public LnrpcInvoice paymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A bare-bones invoice for a payment within the Lightning Network. With the details of the invoice, the sender has all the data necessary to send a payment to the recipient. Note: Output only, don't specify for creating an invoice.")
    public String getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public LnrpcInvoice descriptionHash(byte[] descriptionHash) {
        this.descriptionHash = descriptionHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hash (SHA-256) of a description of the payment. Used if the description of payment (memo) is too long to naturally fit within the description field of an encoded payment request. When using REST, this field must be encoded as base64.")
    public byte[] getDescriptionHash() {
        return this.descriptionHash;
    }

    public void setDescriptionHash(byte[] descriptionHash) {
        this.descriptionHash = descriptionHash;
    }

    public LnrpcInvoice expiry(String expiry) {
        this.expiry = expiry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Payment request expiry time in seconds. Default is 86400 (24 hours).")
    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public LnrpcInvoice fallbackAddr(String fallbackAddr) {
        this.fallbackAddr = fallbackAddr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fallback on-chain address.")
    public String getFallbackAddr() {
        return this.fallbackAddr;
    }

    public void setFallbackAddr(String fallbackAddr) {
        this.fallbackAddr = fallbackAddr;
    }

    public LnrpcInvoice cltvExpiry(String cltvExpiry) {
        this.cltvExpiry = cltvExpiry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Delta to use for the time-lock of the CLTV extended to the final hop.")
    public String getCltvExpiry() {
        return this.cltvExpiry;
    }

    public void setCltvExpiry(String cltvExpiry) {
        this.cltvExpiry = cltvExpiry;
    }

    public LnrpcInvoice routeHints(List<LnrpcRouteHint> routeHints) {
        this.routeHints = routeHints;
        return this;
    }

    public LnrpcInvoice addRouteHintsItem(LnrpcRouteHint routeHintsItem) {
        if (this.routeHints == null) {
            this.routeHints = new ArrayList<LnrpcRouteHint>();
        }
        this.routeHints.add(routeHintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Route hints that can each be individually used to assist in reaching the invoice's destination.")
    public List<LnrpcRouteHint> getRouteHints() {
        return this.routeHints;
    }

    public void setRouteHints(List<LnrpcRouteHint> routeHints) {
        this.routeHints = routeHints;
    }

    public LnrpcInvoice _private(Boolean _private) {
        this._private = _private;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this invoice should include routing hints for private channels. Note: When enabled, if value and value_msat are zero, a large number of hints with these channels can be included, which might not be desirable.")
    public Boolean getPrivate() {
        return this._private;
    }

    public void setPrivate(Boolean _private) {
        this._private = _private;
    }

    public LnrpcInvoice addIndex(String addIndex) {
        this.addIndex = addIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"add\" index of this invoice. Each newly created invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all added invoices with an add_index greater than this one. Note: Output only, don't specify for creating an invoice.")
    public String getAddIndex() {
        return this.addIndex;
    }

    public void setAddIndex(String addIndex) {
        this.addIndex = addIndex;
    }

    public LnrpcInvoice settleIndex(String settleIndex) {
        this.settleIndex = settleIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"settle\" index of this invoice. Each newly settled invoice will increment this index making it monotonically increasing. Callers to the SubscribeInvoices call can use this to instantly get notified of all settled invoices with an settle_index greater than this one. Note: Output only, don't specify for creating an invoice.")
    public String getSettleIndex() {
        return this.settleIndex;
    }

    public void setSettleIndex(String settleIndex) {
        this.settleIndex = settleIndex;
    }

    public LnrpcInvoice amtPaid(String amtPaid) {
        this.amtPaid = amtPaid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated, use amt_paid_sat or amt_paid_msat.")
    public String getAmtPaid() {
        return this.amtPaid;
    }

    public void setAmtPaid(String amtPaid) {
        this.amtPaid = amtPaid;
    }

    public LnrpcInvoice amtPaidSat(String amtPaidSat) {
        this.amtPaidSat = amtPaidSat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount that was accepted for this invoice, in satoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it's possible that the sender paid MORE that was specified in the original invoice. So we'll record that here as well. Note: Output only, don't specify for creating an invoice.")
    public String getAmtPaidSat() {
        return this.amtPaidSat;
    }

    public void setAmtPaidSat(String amtPaidSat) {
        this.amtPaidSat = amtPaidSat;
    }

    public LnrpcInvoice amtPaidMsat(String amtPaidMsat) {
        this.amtPaidMsat = amtPaidMsat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount that was accepted for this invoice, in millisatoshis. This will ONLY be set if this invoice has been settled. We provide this field as if the invoice was created with a zero value, then we need to record what amount was ultimately accepted. Additionally, it's possible that the sender paid MORE that was specified in the original invoice. So we'll record that here as well. Note: Output only, don't specify for creating an invoice.")
    public String getAmtPaidMsat() {
        return this.amtPaidMsat;
    }

    public void setAmtPaidMsat(String amtPaidMsat) {
        this.amtPaidMsat = amtPaidMsat;
    }

    public LnrpcInvoice state(InvoiceInvoiceState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InvoiceInvoiceState getState() {
        return this.state;
    }

    public void setState(InvoiceInvoiceState state) {
        this.state = state;
    }

    public LnrpcInvoice htlcs(List<LnrpcInvoiceHTLC> htlcs) {
        this.htlcs = htlcs;
        return this;
    }

    public LnrpcInvoice addHtlcsItem(LnrpcInvoiceHTLC htlcsItem) {
        if (this.htlcs == null) {
            this.htlcs = new ArrayList<LnrpcInvoiceHTLC>();
        }
        this.htlcs.add(htlcsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of HTLCs paying to this invoice [EXPERIMENTAL]. Note: Output only, don't specify for creating an invoice.")
    public List<LnrpcInvoiceHTLC> getHtlcs() {
        return this.htlcs;
    }

    public void setHtlcs(List<LnrpcInvoiceHTLC> htlcs) {
        this.htlcs = htlcs;
    }

    public LnrpcInvoice features(Map<String, LnrpcFeature> features) {
        this.features = features;
        return this;
    }

    public LnrpcInvoice putFeaturesItem(String key, LnrpcFeature featuresItem) {
        if (this.features == null) {
            this.features = new HashMap<String, LnrpcFeature>();
        }
        this.features.put(key, featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of features advertised on the invoice. Note: Output only, don't specify for creating an invoice.")
    public Map<String, LnrpcFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, LnrpcFeature> features) {
        this.features = features;
    }

    public LnrpcInvoice isKeysend(Boolean isKeysend) {
        this.isKeysend = isKeysend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if this invoice was a spontaneous payment that arrived via keysend [EXPERIMENTAL]. Note: Output only, don't specify for creating an invoice.")
    public Boolean getIsKeysend() {
        return this.isKeysend;
    }

    public void setIsKeysend(Boolean isKeysend) {
        this.isKeysend = isKeysend;
    }

    public LnrpcInvoice paymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment address of this invoice. This value will be used in MPP payments, and also for newer invoices that always require the MPP payload for added end-to-end security. Note: Output only, don't specify for creating an invoice.")
    public byte[] getPaymentAddr() {
        return this.paymentAddr;
    }

    public void setPaymentAddr(byte[] paymentAddr) {
        this.paymentAddr = paymentAddr;
    }

    public LnrpcInvoice isAmp(Boolean isAmp) {
        this.isAmp = isAmp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Signals whether or not this is an AMP invoice.")
    public Boolean getIsAmp() {
        return this.isAmp;
    }

    public void setIsAmp(Boolean isAmp) {
        this.isAmp = isAmp;
    }

    public LnrpcInvoice ampInvoiceState(Map<String, LnrpcAMPInvoiceState> ampInvoiceState) {
        this.ampInvoiceState = ampInvoiceState;
        return this;
    }

    public LnrpcInvoice putAmpInvoiceStateItem(String key, LnrpcAMPInvoiceState ampInvoiceStateItem) {
        if (this.ampInvoiceState == null) {
            this.ampInvoiceState = new HashMap<String, LnrpcAMPInvoiceState>();
        }
        this.ampInvoiceState.put(key, ampInvoiceStateItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maps a 32-byte hex-encoded set ID to the sub-invoice AMP state for the given set ID. This field is always populated for AMP invoices, and can be used along side LookupInvoice to obtain the HTLC information related to a given sub-invoice. Note: Output only, don't specify for creating an invoice.")
    public Map<String, LnrpcAMPInvoiceState> getAmpInvoiceState() {
        return this.ampInvoiceState;
    }

    public void setAmpInvoiceState(Map<String, LnrpcAMPInvoiceState> ampInvoiceState) {
        this.ampInvoiceState = ampInvoiceState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LnrpcInvoice lnrpcInvoice = (LnrpcInvoice)o;
        return Objects.equals(this.memo, lnrpcInvoice.memo) && Arrays.equals(this.rPreimage, lnrpcInvoice.rPreimage) && Arrays.equals(this.rHash, lnrpcInvoice.rHash) && Objects.equals(this.value, lnrpcInvoice.value) && Objects.equals(this.valueMsat, lnrpcInvoice.valueMsat) && Objects.equals(this.settled, lnrpcInvoice.settled) && Objects.equals(this.creationDate, lnrpcInvoice.creationDate) && Objects.equals(this.settleDate, lnrpcInvoice.settleDate) && Objects.equals(this.paymentRequest, lnrpcInvoice.paymentRequest) && Arrays.equals(this.descriptionHash, lnrpcInvoice.descriptionHash) && Objects.equals(this.expiry, lnrpcInvoice.expiry) && Objects.equals(this.fallbackAddr, lnrpcInvoice.fallbackAddr) && Objects.equals(this.cltvExpiry, lnrpcInvoice.cltvExpiry) && Objects.equals(this.routeHints, lnrpcInvoice.routeHints) && Objects.equals(this._private, lnrpcInvoice._private) && Objects.equals(this.addIndex, lnrpcInvoice.addIndex) && Objects.equals(this.settleIndex, lnrpcInvoice.settleIndex) && Objects.equals(this.amtPaid, lnrpcInvoice.amtPaid) && Objects.equals(this.amtPaidSat, lnrpcInvoice.amtPaidSat) && Objects.equals(this.amtPaidMsat, lnrpcInvoice.amtPaidMsat) && Objects.equals((Object)this.state, (Object)lnrpcInvoice.state) && Objects.equals(this.htlcs, lnrpcInvoice.htlcs) && Objects.equals(this.features, lnrpcInvoice.features) && Objects.equals(this.isKeysend, lnrpcInvoice.isKeysend) && Arrays.equals(this.paymentAddr, lnrpcInvoice.paymentAddr) && Objects.equals(this.isAmp, lnrpcInvoice.isAmp) && Objects.equals(this.ampInvoiceState, lnrpcInvoice.ampInvoiceState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.memo, Arrays.hashCode(this.rPreimage), Arrays.hashCode(this.rHash), this.value, this.valueMsat, this.settled, this.creationDate, this.settleDate, this.paymentRequest, Arrays.hashCode(this.descriptionHash), this.expiry, this.fallbackAddr, this.cltvExpiry, this.routeHints, this._private, this.addIndex, this.settleIndex, this.amtPaid, this.amtPaidSat, this.amtPaidMsat, this.state, this.htlcs, this.features, this.isKeysend, Arrays.hashCode(this.paymentAddr), this.isAmp, this.ampInvoiceState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LnrpcInvoice {\n");
        sb.append("    memo: ").append(this.toIndentedString(this.memo)).append("\n");
        sb.append("    rPreimage: ").append(this.toIndentedString(this.rPreimage)).append("\n");
        sb.append("    rHash: ").append(this.toIndentedString(this.rHash)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueMsat: ").append(this.toIndentedString(this.valueMsat)).append("\n");
        sb.append("    settled: ").append(this.toIndentedString(this.settled)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    settleDate: ").append(this.toIndentedString(this.settleDate)).append("\n");
        sb.append("    paymentRequest: ").append(this.toIndentedString(this.paymentRequest)).append("\n");
        sb.append("    descriptionHash: ").append(this.toIndentedString(this.descriptionHash)).append("\n");
        sb.append("    expiry: ").append(this.toIndentedString(this.expiry)).append("\n");
        sb.append("    fallbackAddr: ").append(this.toIndentedString(this.fallbackAddr)).append("\n");
        sb.append("    cltvExpiry: ").append(this.toIndentedString(this.cltvExpiry)).append("\n");
        sb.append("    routeHints: ").append(this.toIndentedString(this.routeHints)).append("\n");
        sb.append("    _private: ").append(this.toIndentedString(this._private)).append("\n");
        sb.append("    addIndex: ").append(this.toIndentedString(this.addIndex)).append("\n");
        sb.append("    settleIndex: ").append(this.toIndentedString(this.settleIndex)).append("\n");
        sb.append("    amtPaid: ").append(this.toIndentedString(this.amtPaid)).append("\n");
        sb.append("    amtPaidSat: ").append(this.toIndentedString(this.amtPaidSat)).append("\n");
        sb.append("    amtPaidMsat: ").append(this.toIndentedString(this.amtPaidMsat)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    htlcs: ").append(this.toIndentedString(this.htlcs)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    isKeysend: ").append(this.toIndentedString(this.isKeysend)).append("\n");
        sb.append("    paymentAddr: ").append(this.toIndentedString(this.paymentAddr)).append("\n");
        sb.append("    isAmp: ").append(this.toIndentedString(this.isAmp)).append("\n");
        sb.append("    ampInvoiceState: ").append(this.toIndentedString(this.ampInvoiceState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

